/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.sstoehr.harreader.model.HarContent;
import de.sstoehr.harreader.model.HarCookie;
import de.sstoehr.harreader.model.HarHeader;
import de.sstoehr.harreader.model.HttpStatus;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HarResponse {
    protected static final Long DEFAULT_SIZE = -1L;
    private HttpStatus status;
    private String statusText;
    private String httpVersion;
    private List<HarCookie> cookies;
    private List<HarHeader> headers;
    private HarContent content;
    private String redirectURL;
    private Long headersSize;
    private Long bodySize;
    private String comment;

    public int getStatus() {
        if (this.status == null) {
            this.status = HttpStatus.UNKNOWN_HTTP_STATUS;
        }
        return this.status.getCode();
    }

    public void setStatus(int status) {
        this.status = HttpStatus.byCode(status);
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public List<HarCookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new ArrayList<HarCookie>();
        }
        return this.cookies;
    }

    public void setCookies(List<HarCookie> cookies) {
        this.cookies = cookies;
    }

    public List<HarHeader> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<HarHeader>();
        }
        return this.headers;
    }

    public void setHeaders(List<HarHeader> headers) {
        this.headers = headers;
    }

    public HarContent getContent() {
        if (this.content == null) {
            this.content = new HarContent();
        }
        return this.content;
    }

    public void setContent(HarContent content) {
        this.content = content;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public Long getHeadersSize() {
        if (this.headersSize == null) {
            return DEFAULT_SIZE;
        }
        return this.headersSize;
    }

    public void setHeadersSize(Long headersSize) {
        this.headersSize = headersSize;
    }

    public Long getBodySize() {
        if (this.bodySize == null) {
            return DEFAULT_SIZE;
        }
        return this.bodySize;
    }

    public void setBodySize(Long bodySize) {
        this.bodySize = bodySize;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

