/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.sstoehr.harreader.AbstractHarIO;
import de.sstoehr.harreader.HarReaderException;
import de.sstoehr.harreader.HarReaderMode;
import de.sstoehr.harreader.jackson.MapperFactory;
import de.sstoehr.harreader.model.Har;
import java.io.File;
import java.io.IOException;

public class HarReader
extends AbstractHarIO {
    public HarReader() {
    }

    public HarReader(MapperFactory mapperFactory) {
        super(mapperFactory);
    }

    public Har readFromFile(File har) throws HarReaderException {
        return this.readFromFile(har, HarReaderMode.STRICT);
    }

    public Har readFromFile(File har, HarReaderMode mode) throws HarReaderException {
        ObjectMapper mapper = this.getMapperFactory().instance(mode);
        try {
            return (Har)mapper.readValue(har, Har.class);
        }
        catch (IOException e) {
            throw new HarReaderException(e);
        }
    }

    public Har readFromString(String har) throws HarReaderException {
        return this.readFromString(har, HarReaderMode.STRICT);
    }

    public Har readFromString(String har, HarReaderMode mode) throws HarReaderException {
        ObjectMapper mapper = this.getMapperFactory().instance(mode);
        try {
            return (Har)mapper.readValue(har, Har.class);
        }
        catch (IOException e) {
            throw new HarReaderException(e);
        }
    }
}

