/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.sstoehr.harreader.model.HarCache;
import de.sstoehr.harreader.model.HarRequest;
import de.sstoehr.harreader.model.HarResponse;
import de.sstoehr.harreader.model.HarTiming;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public record HarEntry(@Nullable String pageref, @Nullable @JsonFormat(shape=JsonFormat.Shape.STRING) ZonedDateTime startedDateTime, @Nullable Integer time, @Nonnull HarRequest request, @Nonnull HarResponse response, @Nonnull HarCache cache, @Nonnull HarTiming timings, @Nullable String serverIPAddress, @Nullable String connection, @Nullable String comment, @Nonnull Map<String, Object> additional) {
    public HarEntry() {
        this(null, null, null, new HarRequest(), new HarResponse(), new HarCache(), new HarTiming(), null, null, null, new HashMap<String, Object>());
    }

    public HarEntry(@Nullable String pageref, @Nullable ZonedDateTime startedDateTime, @Nullable Integer time, @Nullable HarRequest request, @Nullable HarResponse response, @Nullable HarCache cache, @Nullable HarTiming timings, @Nullable String serverIPAddress, @Nullable String connection, @Nullable String comment, @Nullable Map<String, Object> additional) {
        this.pageref = pageref;
        this.startedDateTime = startedDateTime;
        this.time = time;
        this.request = request == null ? new HarRequest() : request;
        this.response = response == null ? new HarResponse() : response;
        this.cache = cache == null ? new HarCache() : cache;
        this.timings = timings == null ? new HarTiming() : timings;
        this.serverIPAddress = serverIPAddress;
        this.connection = connection;
        this.comment = comment;
        this.additional = additional == null ? new HashMap() : additional;
    }

    @JsonAnySetter
    public void setAdditionalField(String key, Object value) {
        this.additional.put(key, value);
    }

    @Generated
    public static HarEntryBuilder builder() {
        return new HarEntryBuilder();
    }

    @Generated
    public HarEntryBuilder toBuilder() {
        return new HarEntryBuilder().pageref(this.pageref).startedDateTime(this.startedDateTime).time(this.time).request(this.request).response(this.response).cache(this.cache).timings(this.timings).serverIPAddress(this.serverIPAddress).connection(this.connection).comment(this.comment).additional(this.additional);
    }

    @Generated
    public static class HarEntryBuilder {
        @Generated
        private String pageref;
        @Generated
        private ZonedDateTime startedDateTime;
        @Generated
        private Integer time;
        @Generated
        private HarRequest request;
        @Generated
        private HarResponse response;
        @Generated
        private HarCache cache;
        @Generated
        private HarTiming timings;
        @Generated
        private String serverIPAddress;
        @Generated
        private String connection;
        @Generated
        private String comment;
        @Generated
        private Map<String, Object> additional;

        @Generated
        HarEntryBuilder() {
        }

        @Generated
        public HarEntryBuilder pageref(@Nullable String pageref) {
            this.pageref = pageref;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING)
        @Generated
        public HarEntryBuilder startedDateTime(@Nullable ZonedDateTime startedDateTime) {
            this.startedDateTime = startedDateTime;
            return this;
        }

        @Generated
        public HarEntryBuilder time(@Nullable Integer time) {
            this.time = time;
            return this;
        }

        @Generated
        public HarEntryBuilder request(@Nonnull HarRequest request) {
            if (request == null) {
                throw new NullPointerException("request is marked non-null but is null");
            }
            this.request = request;
            return this;
        }

        @Generated
        public HarEntryBuilder response(@Nonnull HarResponse response) {
            if (response == null) {
                throw new NullPointerException("response is marked non-null but is null");
            }
            this.response = response;
            return this;
        }

        @Generated
        public HarEntryBuilder cache(@Nonnull HarCache cache) {
            if (cache == null) {
                throw new NullPointerException("cache is marked non-null but is null");
            }
            this.cache = cache;
            return this;
        }

        @Generated
        public HarEntryBuilder timings(@Nonnull HarTiming timings) {
            if (timings == null) {
                throw new NullPointerException("timings is marked non-null but is null");
            }
            this.timings = timings;
            return this;
        }

        @Generated
        public HarEntryBuilder serverIPAddress(@Nullable String serverIPAddress) {
            this.serverIPAddress = serverIPAddress;
            return this;
        }

        @Generated
        public HarEntryBuilder connection(@Nullable String connection) {
            this.connection = connection;
            return this;
        }

        @Generated
        public HarEntryBuilder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public HarEntryBuilder additional(@Nonnull Map<String, Object> additional) {
            if (additional == null) {
                throw new NullPointerException("additional is marked non-null but is null");
            }
            this.additional = additional;
            return this;
        }

        @Generated
        public HarEntry build() {
            return new HarEntry(this.pageref, this.startedDateTime, this.time, this.request, this.response, this.cache, this.timings, this.serverIPAddress, this.connection, this.comment, this.additional);
        }

        @Generated
        public String toString() {
            return "HarEntry.HarEntryBuilder(pageref=" + this.pageref + ", startedDateTime=" + String.valueOf(this.startedDateTime) + ", time=" + this.time + ", request=" + String.valueOf(this.request) + ", response=" + String.valueOf(this.response) + ", cache=" + String.valueOf(this.cache) + ", timings=" + String.valueOf(this.timings) + ", serverIPAddress=" + this.serverIPAddress + ", connection=" + this.connection + ", comment=" + this.comment + ", additional=" + String.valueOf(this.additional) + ")";
        }
    }
}

