/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.sstoehr.harreader.model.HarCreatorBrowser;
import de.sstoehr.harreader.model.HarEntry;
import de.sstoehr.harreader.model.HarPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public record HarLog(@Nonnull String version, @Nonnull HarCreatorBrowser creator, @Nullable HarCreatorBrowser browser, @Nonnull List<HarPage> pages, @Nonnull List<HarEntry> entries, @Nullable String comment, @Nonnull Map<String, Object> additional) {
    protected static final String DEFAULT_VERSION = "1.1";

    public HarLog() {
        this(DEFAULT_VERSION, new HarCreatorBrowser(), null, Collections.emptyList(), Collections.emptyList(), null, new HashMap<String, Object>());
    }

    public HarLog(@Nullable String version, @Nullable HarCreatorBrowser creator, @Nullable HarCreatorBrowser browser, @Nullable List<HarPage> pages, @Nullable List<HarEntry> entries, @Nullable String comment, @Nullable Map<String, Object> additional) {
        this.version = version == null || version.isBlank() ? DEFAULT_VERSION : version;
        this.creator = creator == null ? new HarCreatorBrowser() : creator;
        this.browser = browser;
        this.pages = pages == null ? Collections.emptyList() : pages;
        this.entries = entries == null ? Collections.emptyList() : entries;
        this.comment = comment;
        this.additional = additional == null ? new HashMap() : additional;
    }

    @JsonAnySetter
    public void setAdditionalField(String key, Object value) {
        this.additional.put(key, value);
    }

    @Generated
    public static HarLogBuilder builder() {
        return new HarLogBuilder();
    }

    @Generated
    public HarLogBuilder toBuilder() {
        HarLogBuilder builder = new HarLogBuilder().version(this.version).creator(this.creator).browser(this.browser).comment(this.comment).additional(this.additional);
        if (this.pages != null) {
            builder.pages(this.pages);
        }
        if (this.entries != null) {
            builder.entries(this.entries);
        }
        return builder;
    }

    @Generated
    public static class HarLogBuilder {
        @Generated
        private String version;
        @Generated
        private HarCreatorBrowser creator;
        @Generated
        private HarCreatorBrowser browser;
        @Generated
        private ArrayList<HarPage> pages;
        @Generated
        private ArrayList<HarEntry> entries;
        @Generated
        private String comment;
        @Generated
        private Map<String, Object> additional;

        @Generated
        HarLogBuilder() {
        }

        @Generated
        public HarLogBuilder version(@Nonnull String version) {
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            this.version = version;
            return this;
        }

        @Generated
        public HarLogBuilder creator(@Nonnull HarCreatorBrowser creator) {
            if (creator == null) {
                throw new NullPointerException("creator is marked non-null but is null");
            }
            this.creator = creator;
            return this;
        }

        @Generated
        public HarLogBuilder browser(@Nullable HarCreatorBrowser browser) {
            this.browser = browser;
            return this;
        }

        @Generated
        public HarLogBuilder page(HarPage page) {
            if (this.pages == null) {
                this.pages = new ArrayList();
            }
            this.pages.add(page);
            return this;
        }

        @Generated
        public HarLogBuilder pages(Collection<? extends HarPage> pages) {
            if (pages == null) {
                throw new NullPointerException("pages cannot be null");
            }
            if (this.pages == null) {
                this.pages = new ArrayList();
            }
            this.pages.addAll(pages);
            return this;
        }

        @Generated
        public HarLogBuilder clearPages() {
            if (this.pages != null) {
                this.pages.clear();
            }
            return this;
        }

        @Generated
        public HarLogBuilder entry(HarEntry entry) {
            if (this.entries == null) {
                this.entries = new ArrayList();
            }
            this.entries.add(entry);
            return this;
        }

        @Generated
        public HarLogBuilder entries(Collection<? extends HarEntry> entries) {
            if (entries == null) {
                throw new NullPointerException("entries cannot be null");
            }
            if (this.entries == null) {
                this.entries = new ArrayList();
            }
            this.entries.addAll(entries);
            return this;
        }

        @Generated
        public HarLogBuilder clearEntries() {
            if (this.entries != null) {
                this.entries.clear();
            }
            return this;
        }

        @Generated
        public HarLogBuilder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public HarLogBuilder additional(@Nonnull Map<String, Object> additional) {
            if (additional == null) {
                throw new NullPointerException("additional is marked non-null but is null");
            }
            this.additional = additional;
            return this;
        }

        @Generated
        public HarLog build() {
            return new HarLog(this.version, this.creator, this.browser, switch (this.pages == null ? 0 : this.pages.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.pages.get(0));
                default -> Collections.unmodifiableList(new ArrayList<HarPage>(this.pages));
            }, switch (this.entries == null ? 0 : this.entries.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.entries.get(0));
                default -> Collections.unmodifiableList(new ArrayList<HarEntry>(this.entries));
            }, this.comment, this.additional);
        }

        @Generated
        public String toString() {
            return "HarLog.HarLogBuilder(version=" + this.version + ", creator=" + String.valueOf(this.creator) + ", browser=" + String.valueOf(this.browser) + ", pages=" + String.valueOf(this.pages) + ", entries=" + String.valueOf(this.entries) + ", comment=" + this.comment + ", additional=" + String.valueOf(this.additional) + ")";
        }
    }
}

