/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.sstoehr.harreader.model.HarContent;
import de.sstoehr.harreader.model.HarCookie;
import de.sstoehr.harreader.model.HarHeader;
import de.sstoehr.harreader.model.HttpStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public record HarResponse(int status, @Nullable String statusText, @Nullable String httpVersion, @Nonnull List<HarCookie> cookies, @Nonnull List<HarHeader> headers, @Nonnull HarContent content, @Nullable String redirectURL, @Nonnull Long headersSize, @Nonnull Long bodySize, @Nullable String comment, @Nonnull Map<String, Object> additional) {
    protected static final Long DEFAULT_SIZE = -1L;

    public HarResponse() {
        this(HttpStatus.UNKNOWN_HTTP_STATUS.getCode(), null, null, Collections.emptyList(), Collections.emptyList(), new HarContent(), null, DEFAULT_SIZE, DEFAULT_SIZE, null, new HashMap<String, Object>());
    }

    public HarResponse(int status, @Nullable String statusText, @Nullable String httpVersion, @Nullable List<HarCookie> cookies, @Nullable List<HarHeader> headers, @Nullable HarContent content, @Nullable String redirectURL, @Nullable Long headersSize, @Nullable Long bodySize, @Nullable String comment, @Nullable Map<String, Object> additional) {
        this.status = status;
        this.statusText = statusText;
        this.httpVersion = httpVersion;
        this.cookies = cookies == null ? Collections.emptyList() : cookies;
        this.headers = headers == null ? Collections.emptyList() : headers;
        this.content = content == null ? new HarContent() : content;
        this.redirectURL = redirectURL;
        this.headersSize = headersSize == null ? DEFAULT_SIZE : headersSize;
        this.bodySize = bodySize == null ? DEFAULT_SIZE : bodySize;
        this.comment = comment;
        this.additional = additional == null ? new HashMap() : additional;
    }

    @JsonIgnore
    public HttpStatus httpStatus() {
        return HttpStatus.byCode(this.status);
    }

    @JsonAnySetter
    public void setAdditionalField(String key, Object value) {
        this.additional.put(key, value);
    }

    @Generated
    public static HarResponseBuilder builder() {
        return new HarResponseBuilder();
    }

    @Generated
    public HarResponseBuilder toBuilder() {
        HarResponseBuilder builder = new HarResponseBuilder().status(this.status).statusText(this.statusText).httpVersion(this.httpVersion).content(this.content).redirectURL(this.redirectURL).headersSize(this.headersSize).bodySize(this.bodySize).comment(this.comment).additional(this.additional);
        if (this.cookies != null) {
            builder.cookies(this.cookies);
        }
        if (this.headers != null) {
            builder.headers(this.headers);
        }
        return builder;
    }

    @Generated
    public static class HarResponseBuilder {
        @Generated
        private int status;
        @Generated
        private String statusText;
        @Generated
        private String httpVersion;
        @Generated
        private ArrayList<HarCookie> cookies;
        @Generated
        private ArrayList<HarHeader> headers;
        @Generated
        private HarContent content;
        @Generated
        private String redirectURL;
        @Generated
        private Long headersSize;
        @Generated
        private Long bodySize;
        @Generated
        private String comment;
        @Generated
        private Map<String, Object> additional;

        @Generated
        HarResponseBuilder() {
        }

        @Generated
        public HarResponseBuilder status(int status) {
            this.status = status;
            return this;
        }

        @Generated
        public HarResponseBuilder statusText(@Nullable String statusText) {
            this.statusText = statusText;
            return this;
        }

        @Generated
        public HarResponseBuilder httpVersion(@Nullable String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Generated
        public HarResponseBuilder cookie(HarCookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList();
            }
            this.cookies.add(cookie);
            return this;
        }

        @Generated
        public HarResponseBuilder cookies(Collection<? extends HarCookie> cookies) {
            if (cookies == null) {
                throw new NullPointerException("cookies cannot be null");
            }
            if (this.cookies == null) {
                this.cookies = new ArrayList();
            }
            this.cookies.addAll(cookies);
            return this;
        }

        @Generated
        public HarResponseBuilder clearCookies() {
            if (this.cookies != null) {
                this.cookies.clear();
            }
            return this;
        }

        @Generated
        public HarResponseBuilder header(HarHeader header) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(header);
            return this;
        }

        @Generated
        public HarResponseBuilder headers(Collection<? extends HarHeader> headers) {
            if (headers == null) {
                throw new NullPointerException("headers cannot be null");
            }
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.addAll(headers);
            return this;
        }

        @Generated
        public HarResponseBuilder clearHeaders() {
            if (this.headers != null) {
                this.headers.clear();
            }
            return this;
        }

        @Generated
        public HarResponseBuilder content(@Nonnull HarContent content) {
            if (content == null) {
                throw new NullPointerException("content is marked non-null but is null");
            }
            this.content = content;
            return this;
        }

        @Generated
        public HarResponseBuilder redirectURL(@Nullable String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        @Generated
        public HarResponseBuilder headersSize(@Nonnull Long headersSize) {
            if (headersSize == null) {
                throw new NullPointerException("headersSize is marked non-null but is null");
            }
            this.headersSize = headersSize;
            return this;
        }

        @Generated
        public HarResponseBuilder bodySize(@Nonnull Long bodySize) {
            if (bodySize == null) {
                throw new NullPointerException("bodySize is marked non-null but is null");
            }
            this.bodySize = bodySize;
            return this;
        }

        @Generated
        public HarResponseBuilder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public HarResponseBuilder additional(@Nonnull Map<String, Object> additional) {
            if (additional == null) {
                throw new NullPointerException("additional is marked non-null but is null");
            }
            this.additional = additional;
            return this;
        }

        @Generated
        public HarResponse build() {
            return new HarResponse(this.status, this.statusText, this.httpVersion, switch (this.cookies == null ? 0 : this.cookies.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.cookies.get(0));
                default -> Collections.unmodifiableList(new ArrayList<HarCookie>(this.cookies));
            }, switch (this.headers == null ? 0 : this.headers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.headers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<HarHeader>(this.headers));
            }, this.content, this.redirectURL, this.headersSize, this.bodySize, this.comment, this.additional);
        }

        @Generated
        public String toString() {
            return "HarResponse.HarResponseBuilder(status=" + this.status + ", statusText=" + this.statusText + ", httpVersion=" + this.httpVersion + ", cookies=" + String.valueOf(this.cookies) + ", headers=" + String.valueOf(this.headers) + ", content=" + String.valueOf(this.content) + ", redirectURL=" + this.redirectURL + ", headersSize=" + this.headersSize + ", bodySize=" + this.bodySize + ", comment=" + this.comment + ", additional=" + String.valueOf(this.additional) + ")";
        }
    }
}

