/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.sstoehr.harreader.AbstractHarIO;
import de.sstoehr.harreader.HarReaderException;
import de.sstoehr.harreader.HarReaderMode;
import de.sstoehr.harreader.jackson.MapperFactory;
import de.sstoehr.harreader.model.Har;
import java.io.File;
import java.io.InputStream;

public class HarReader
extends AbstractHarIO {
    private static final HarReaderMode DEFAULT_READER_MODE = HarReaderMode.STRICT;

    public HarReader() {
    }

    public HarReader(MapperFactory mapperFactory) {
        super(mapperFactory);
    }

    public Har readFromFile(File har) throws HarReaderException {
        return this.readFromFile(har, DEFAULT_READER_MODE);
    }

    public Har readFromFile(File har, HarReaderMode mode) throws HarReaderException {
        return this.wrap(mode, mapper -> (Har)mapper.readValue(har, Har.class));
    }

    public Har readFromInputStream(InputStream harInputStream) throws HarReaderException {
        return this.readFromInputStream(harInputStream, DEFAULT_READER_MODE);
    }

    public Har readFromInputStream(InputStream harInputStream, HarReaderMode mode) throws HarReaderException {
        return this.wrap(mode, mapper -> (Har)mapper.readValue(harInputStream, Har.class));
    }

    public Har readFromString(String har) throws HarReaderException {
        return this.readFromString(har, DEFAULT_READER_MODE);
    }

    public Har readFromString(String har, HarReaderMode mode) throws HarReaderException {
        return this.wrap(mode, mapper -> (Har)mapper.readValue(har, Har.class));
    }

    public Har readFromBytes(byte[] bytes) throws HarReaderException {
        return this.readFromBytes(bytes, DEFAULT_READER_MODE);
    }

    public Har readFromBytes(byte[] bytes, HarReaderMode mode) throws HarReaderException {
        return this.wrap(mode, mapper -> (Har)mapper.readValue(bytes, Har.class));
    }

    private <T> T wrap(HarReaderMode mode, AbstractHarIO.IOFunction<ObjectMapper, T> consumer) throws HarReaderException {
        return HarReader.wrap(this.getMapperFactory().instance(mode), consumer, HarReaderException::new);
    }
}

