/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.sstoehr.harreader.AbstractHarIO;
import de.sstoehr.harreader.HarWriterException;
import de.sstoehr.harreader.jackson.MapperFactory;
import de.sstoehr.harreader.model.Har;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;

public final class HarWriter
extends AbstractHarIO {
    public HarWriter() {
    }

    public HarWriter(MapperFactory mapperFactory) {
        super(mapperFactory);
    }

    public String writeAsString(Har har) throws HarWriterException {
        return this.wrap(m -> m.writeValueAsString((Object)har));
    }

    public byte[] writeAsBytes(Har har) throws HarWriterException {
        return this.wrap(m -> m.writeValueAsBytes((Object)har));
    }

    public void writeTo(Writer writer, Har har) throws HarWriterException {
        this.wrap(m -> {
            m.writeValue(writer, (Object)har);
            return null;
        });
    }

    public void writeTo(OutputStream os, Har har) throws HarWriterException {
        this.wrap(m -> {
            m.writeValue(os, (Object)har);
            return null;
        });
    }

    public void writeTo(File file, Har har) throws HarWriterException {
        this.wrap(m -> {
            m.writeValue(file, (Object)har);
            return null;
        });
    }

    private <T> T wrap(AbstractHarIO.IOFunction<ObjectMapper, T> consumer) throws HarWriterException {
        return HarWriter.wrap(this.getMapperFactory().instance(), consumer, HarWriterException::new);
    }
}

