/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.sstoehr.harreader.HarReaderMode;
import de.sstoehr.harreader.jackson.ExceptionIgnoringIntegerDeserializer;
import de.sstoehr.harreader.jackson.ExceptionIgnoringZonedDateTimeDeserializer;
import de.sstoehr.harreader.jackson.MapperFactory;
import java.time.ZonedDateTime;

public class DefaultMapperFactory
implements MapperFactory {
    @Override
    public ObjectMapper instance(HarReaderMode mode) {
        SimpleModule module = new SimpleModule();
        if (mode == HarReaderMode.LAX) {
            module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ExceptionIgnoringZonedDateTimeDeserializer());
            module.addDeserializer(Integer.class, (JsonDeserializer)new ExceptionIgnoringIntegerDeserializer());
        }
        return this.instance().registerModule((Module)module);
    }

    @Override
    public ObjectMapper instance() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false);
        return mapper;
    }
}

