/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.sstoehr.harreader.model.HarCookie;
import de.sstoehr.harreader.model.HarHeader;
import de.sstoehr.harreader.model.HarPostData;
import de.sstoehr.harreader.model.HarQueryParam;
import de.sstoehr.harreader.model.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public record HarRequest(@Nullable String method, @Nullable String url, @Nullable String httpVersion, @Nonnull List<HarCookie> cookies, @Nonnull List<HarHeader> headers, @Nonnull List<HarQueryParam> queryString, @Nonnull HarPostData postData, @Nonnull Long headersSize, @Nonnull Long bodySize, @Nullable String comment, @Nonnull Map<String, Object> additional) {
    protected static final Long DEFAULT_SIZE = -1L;

    public HarRequest() {
        this(null, null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new HarPostData(), DEFAULT_SIZE, DEFAULT_SIZE, null, new HashMap<String, Object>());
    }

    public HarRequest(@Nullable String method, @Nullable String url, @Nullable String httpVersion, @Nullable List<HarCookie> cookies, @Nullable List<HarHeader> headers, @Nullable List<HarQueryParam> queryString, @Nullable HarPostData postData, @Nullable Long headersSize, @Nullable Long bodySize, @Nullable String comment, @Nullable Map<String, Object> additional) {
        this.method = method;
        this.url = url;
        this.httpVersion = httpVersion;
        this.cookies = cookies == null ? Collections.emptyList() : cookies;
        this.headers = headers == null ? Collections.emptyList() : headers;
        this.queryString = queryString == null ? Collections.emptyList() : queryString;
        this.postData = postData == null ? new HarPostData() : postData;
        this.headersSize = headersSize == null ? DEFAULT_SIZE : headersSize;
        this.bodySize = bodySize == null ? DEFAULT_SIZE : bodySize;
        this.comment = comment;
        this.additional = additional == null ? new HashMap() : additional;
    }

    @JsonIgnore
    public HttpMethod httpMethod() {
        return HttpMethod.fromString(this.method);
    }

    @JsonAnySetter
    public void setAdditionalField(String key, Object value) {
        this.additional.put(key, value);
    }

    @Generated
    public static HarRequestBuilder builder() {
        return new HarRequestBuilder();
    }

    @Generated
    public HarRequestBuilder toBuilder() {
        HarRequestBuilder builder = new HarRequestBuilder().method(this.method).url(this.url).httpVersion(this.httpVersion).postData(this.postData).headersSize(this.headersSize).bodySize(this.bodySize).comment(this.comment).additional(this.additional);
        if (this.cookies != null) {
            builder.cookies(this.cookies);
        }
        if (this.headers != null) {
            builder.headers(this.headers);
        }
        if (this.queryString != null) {
            builder.queryString(this.queryString);
        }
        return builder;
    }

    @Generated
    public static class HarRequestBuilder {
        @Generated
        private String method;
        @Generated
        private String url;
        @Generated
        private String httpVersion;
        @Generated
        private ArrayList<HarCookie> cookies;
        @Generated
        private ArrayList<HarHeader> headers;
        @Generated
        private ArrayList<HarQueryParam> queryString;
        @Generated
        private HarPostData postData;
        @Generated
        private Long headersSize;
        @Generated
        private Long bodySize;
        @Generated
        private String comment;
        @Generated
        private Map<String, Object> additional;

        @Generated
        HarRequestBuilder() {
        }

        @Generated
        public HarRequestBuilder method(@Nullable String method) {
            this.method = method;
            return this;
        }

        @Generated
        public HarRequestBuilder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        @Generated
        public HarRequestBuilder httpVersion(@Nullable String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Generated
        public HarRequestBuilder cookie(HarCookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList();
            }
            this.cookies.add(cookie);
            return this;
        }

        @Generated
        public HarRequestBuilder cookies(Collection<? extends HarCookie> cookies) {
            if (cookies == null) {
                throw new NullPointerException("cookies cannot be null");
            }
            if (this.cookies == null) {
                this.cookies = new ArrayList();
            }
            this.cookies.addAll(cookies);
            return this;
        }

        @Generated
        public HarRequestBuilder clearCookies() {
            if (this.cookies != null) {
                this.cookies.clear();
            }
            return this;
        }

        @Generated
        public HarRequestBuilder header(HarHeader header) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(header);
            return this;
        }

        @Generated
        public HarRequestBuilder headers(Collection<? extends HarHeader> headers) {
            if (headers == null) {
                throw new NullPointerException("headers cannot be null");
            }
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.addAll(headers);
            return this;
        }

        @Generated
        public HarRequestBuilder clearHeaders() {
            if (this.headers != null) {
                this.headers.clear();
            }
            return this;
        }

        @Generated
        public HarRequestBuilder queryString(HarQueryParam queryString) {
            if (this.queryString == null) {
                this.queryString = new ArrayList();
            }
            this.queryString.add(queryString);
            return this;
        }

        @Generated
        public HarRequestBuilder queryString(Collection<? extends HarQueryParam> queryString) {
            if (queryString == null) {
                throw new NullPointerException("queryString cannot be null");
            }
            if (this.queryString == null) {
                this.queryString = new ArrayList();
            }
            this.queryString.addAll(queryString);
            return this;
        }

        @Generated
        public HarRequestBuilder clearQueryString() {
            if (this.queryString != null) {
                this.queryString.clear();
            }
            return this;
        }

        @Generated
        public HarRequestBuilder postData(@Nonnull HarPostData postData) {
            if (postData == null) {
                throw new NullPointerException("postData is marked non-null but is null");
            }
            this.postData = postData;
            return this;
        }

        @Generated
        public HarRequestBuilder headersSize(@Nonnull Long headersSize) {
            if (headersSize == null) {
                throw new NullPointerException("headersSize is marked non-null but is null");
            }
            this.headersSize = headersSize;
            return this;
        }

        @Generated
        public HarRequestBuilder bodySize(@Nonnull Long bodySize) {
            if (bodySize == null) {
                throw new NullPointerException("bodySize is marked non-null but is null");
            }
            this.bodySize = bodySize;
            return this;
        }

        @Generated
        public HarRequestBuilder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public HarRequestBuilder additional(@Nonnull Map<String, Object> additional) {
            if (additional == null) {
                throw new NullPointerException("additional is marked non-null but is null");
            }
            this.additional = additional;
            return this;
        }

        @Generated
        public HarRequest build() {
            return new HarRequest(this.method, this.url, this.httpVersion, switch (this.cookies == null ? 0 : this.cookies.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.cookies.get(0));
                default -> Collections.unmodifiableList(new ArrayList<HarCookie>(this.cookies));
            }, switch (this.headers == null ? 0 : this.headers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.headers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<HarHeader>(this.headers));
            }, switch (this.queryString == null ? 0 : this.queryString.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.queryString.get(0));
                default -> Collections.unmodifiableList(new ArrayList<HarQueryParam>(this.queryString));
            }, this.postData, this.headersSize, this.bodySize, this.comment, this.additional);
        }

        @Generated
        public String toString() {
            return "HarRequest.HarRequestBuilder(method=" + this.method + ", url=" + this.url + ", httpVersion=" + this.httpVersion + ", cookies=" + String.valueOf(this.cookies) + ", headers=" + String.valueOf(this.headers) + ", queryString=" + String.valueOf(this.queryString) + ", postData=" + String.valueOf(this.postData) + ", headersSize=" + this.headersSize + ", bodySize=" + this.bodySize + ", comment=" + this.comment + ", additional=" + String.valueOf(this.additional) + ")";
        }
    }
}

