/*
 * Decompiled with CFR 0.152.
 */
package ninja.mongodb;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.MongoClient;
import java.net.UnknownHostException;
import java.util.List;
import ninja.utils.NinjaProperties;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MongoDB {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDB.class);
    private static final String MONGODB_HOST = "ninja.mongodb.host";
    private static final String MONGODB_PORT = "ninja.mongodb.port";
    private static final String MONGODB_DBNAME = "ninja.mongodb.dbname";
    private static final String MORPHIA_PACKAGE = "ninja.morphia.package";
    private Datastore datastore;
    private Morphia morphia;
    private MongoClient mongoClient;
    private NinjaProperties ninjaProperties;

    @Inject
    private MongoDB(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
        String string = this.ninjaProperties.get(MONGODB_HOST);
        int n = this.ninjaProperties.getInteger(MONGODB_PORT);
        try {
            this.mongoClient = new MongoClient(string, n);
            LOG.info("Successfully created MongoClient @ " + string + ":" + n);
        }
        catch (UnknownHostException unknownHostException) {
            LOG.error("Failed to created MongoClient @ " + string + ":" + n, (Throwable)unknownHostException);
        }
    }

    public Datastore getDatastore() {
        Preconditions.checkNotNull((Object)this.mongoClient);
        if (this.datastore == null) {
            this.initMorphia(this.mongoClient);
        }
        return this.datastore;
    }

    public Morphia getMorphia() {
        Preconditions.checkNotNull((Object)this.mongoClient);
        if (this.morphia == null) {
            this.initMorphia(this.mongoClient);
        }
        return this.morphia;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void setMongoClient(MongoClient mongoClient) {
        Preconditions.checkNotNull((Object)mongoClient);
        this.mongoClient = mongoClient;
        LOG.info("Successfully set MongoClient @ " + mongoClient.getAddress().getHost() + ":" + mongoClient.getAddress().getPort());
        this.initMorphia(mongoClient);
    }

    private void initMorphia(MongoClient mongoClient) {
        String string = this.ninjaProperties.get(MORPHIA_PACKAGE);
        String string2 = this.ninjaProperties.get(MONGODB_DBNAME);
        this.morphia = new Morphia().mapPackage(string);
        this.datastore = this.morphia.createDatastore(mongoClient, string2);
        LOG.info("Mapped Morphia to package '" + string + "' and created Morphia Datastore to database '" + string2 + "'");
    }

    public <T> T findById(Object object, Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull((Object)object);
        String string = null;
        if (!(object instanceof ObjectId)) {
            string = String.valueOf(object);
        }
        return (T)this.datastore.get(clazz, (Object)new ObjectId(string));
    }

    public <T> List<T> findAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        return this.datastore.find(clazz).asList();
    }

    public <T> long countAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        return this.datastore.find(clazz).countAll();
    }

    public void save(Object object) {
        Preconditions.checkNotNull((Object)object);
        this.datastore.save(object);
    }

    public void delete(Object object) {
        Preconditions.checkNotNull((Object)object);
        this.datastore.delete(object);
    }

    public <T> void deleteAll(Class<T> clazz) {
        this.datastore.delete(this.datastore.createQuery(clazz));
    }

    public void dropDatabase() {
        this.datastore.getDB().dropDatabase();
    }
}

