/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.common.gs1;

import com.google.common.base.Strings;
import de.taimos.common.gs1.GS1Helper;
import de.taimos.common.gs1.GS1Utils;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;

public class GTINHelper {
    public static String createGTIN(String gln, int id) {
        String idPart = Strings.padStart((String)Integer.toString(id), (int)(12 - gln.length()), (char)'0');
        return GS1Utils.addChecksum(gln + idPart);
    }

    public static byte[] getAsEAN13(String gtin) {
        if (gtin != null && !gtin.isEmpty()) {
            EAN13Bean bean = new EAN13Bean();
            return GS1Utils.renderBarcode((AbstractBarcodeBean)bean, gtin);
        }
        return new byte[0];
    }

    public static byte[] getAsGS1_128(String gtin) {
        if (gtin != null && !gtin.isEmpty()) {
            GS1Helper.renderGS1_128(GTINHelper.getGS1128Code(gtin));
        }
        return new byte[0];
    }

    private static String getGS1128Code(String gtin) {
        if (!gtin.matches("[0-9]{13,14}")) {
            return "";
        }
        if (gtin.length() == 13) {
            return "010" + gtin;
        }
        return "01" + gtin;
    }

    public static byte[] getAsBytes(String gtin, String type) {
        byte[] image = new byte[]{};
        switch (type) {
            case "gtin-13": {
                image = GTINHelper.getAsEAN13(gtin);
                break;
            }
            case "gs1-128": {
                image = GTINHelper.getAsGS1_128(gtin);
            }
        }
        return image;
    }
}

