/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.common.gs1;

import com.google.common.base.Strings;
import de.taimos.common.gs1.GS1Helper;
import de.taimos.common.gs1.GS1Utils;

public class SSCCHelper {
    public static String createSSCC(String gln, int id) {
        return SSCCHelper.createSSCC("0", gln, id);
    }

    public static String createSSCC(String extensionDigit, String gln, int id) {
        if (extensionDigit == null || !extensionDigit.matches("[0-9]")) {
            throw new IllegalArgumentException("Invalid extension digit");
        }
        if (gln == null || !gln.matches("[0-9]{7,9}")) {
            throw new IllegalArgumentException("Invalid gln");
        }
        String idPart = Strings.padStart((String)Integer.toString(id), (int)(16 - gln.length()), (char)'0');
        return GS1Utils.addChecksum(extensionDigit + gln + idPart);
    }

    public static byte[] getAsGS1_128(String sscc) {
        if (sscc != null && !sscc.isEmpty() && sscc.matches("[0-9]{18}")) {
            GS1Helper.renderGS1_128("00" + sscc);
        }
        return new byte[0];
    }
}

