/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.eni.pandora.horizon.autoconfigure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import de.telekom.eni.pandora.horizon.exception.CouldNotConstructKubernetesClientException;
import de.telekom.eni.pandora.horizon.kubernetes.InformerStoreInitHandler;
import de.telekom.eni.pandora.horizon.kubernetes.KubernetesClientWrapper;
import de.telekom.eni.pandora.horizon.kubernetes.PodResourceListener;
import de.telekom.eni.pandora.horizon.kubernetes.resource.SubscriptionResource;
import de.telekom.eni.pandora.horizon.kubernetes.util.RoverToken;
import de.telekom.jsonfilter.operator.Operator;
import de.telekom.jsonfilter.serde.OperatorDeserializer;
import de.telekom.jsonfilter.serde.OperatorSerializer;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"kubernetes.enabled"})
@Configuration
public class KubernetesClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KubernetesClientConfiguration.class);
    private static final String KUBERNETES_DEV_CONFIG_FILE_PATH = "kubernetes/config/config.laptop-dev-dev-system";
    @Value(value="${spring.profiles.active:}")
    private String activeProfile;
    @Value(value="${kubernetes.rover.token:}")
    private String roverToken;
    @Value(value="${kubernetes.kubeConfigPath:}")
    private String kubeConfigPath;
    @Value(value="${kubernetes.informer.resyncperiod.ms:600000}")
    private long resyncPeriodInMs;
    @Value(value="${kubernetes.informer.namespace:}")
    private String namespace;
    @Value(value="${kubernetes.informer.pods.namespace:}")
    private String podsNamespace;
    @Value(value="${kubernetes.informer.pods.appname:}")
    private String appName;
    @Value(value="${kubernetes.requestTimeoutMs:120000}")
    private int requestTimeoutInMs;
    @Value(value="${kubernetes.connectionTimeoutMs:120000}")
    private int connectionTimeoutMs;

    /*
     * Exception decompiling
     */
    private String getResourceFileAsString(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Config parseRoverToken(String roverToken) throws JsonProcessingException {
        byte[] decodedBytes = Base64.getDecoder().decode(roverToken);
        RoverToken tokenObject = (RoverToken)new YAMLMapper().readValue(new String(decodedBytes), RoverToken.class);
        return ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(tokenObject.getMasterUrl())).withOauthToken(tokenObject.getToken())).withCaCertData(tokenObject.getCaCertificate())).withDisableHostnameVerification(true)).build();
    }

    private KubernetesClient createClientFromRoverToken(String roverToken) throws CouldNotConstructKubernetesClientException {
        try {
            Config config = this.parseRoverToken(roverToken);
            return new DefaultKubernetesClient(this.withCustomSettings(config));
        }
        catch (Exception e) {
            throw new CouldNotConstructKubernetesClientException("Error: Rover token could not be parsed.", (Throwable)e);
        }
    }

    private KubernetesClient createClientFromBundledConfig() throws CouldNotConstructKubernetesClientException {
        try {
            String configYAML = this.getResourceFileAsString(KUBERNETES_DEV_CONFIG_FILE_PATH);
            if (configYAML == null) {
                throw new FileNotFoundException(String.format("Error: Kubernetes config %1s could not be found.", KUBERNETES_DEV_CONFIG_FILE_PATH));
            }
            Config config = Config.fromKubeconfig((String)configYAML);
            return new DefaultKubernetesClient(this.withCustomSettings(config));
        }
        catch (Exception e) {
            throw new CouldNotConstructKubernetesClientException(String.format("Error: Kubernetes config %1s could not be processed.", KUBERNETES_DEV_CONFIG_FILE_PATH), (Throwable)e);
        }
    }

    private KubernetesClient createClientFromeKubeconfigFile(String path) throws CouldNotConstructKubernetesClientException {
        try {
            File configFile = new File(path);
            String configYAML = String.join((CharSequence)"\n", Files.readAllLines(configFile.toPath(), StandardCharsets.UTF_8));
            Config config = Config.fromKubeconfig((String)configYAML);
            return new DefaultKubernetesClient(this.withCustomSettings(config));
        }
        catch (IOException e) {
            throw new CouldNotConstructKubernetesClientException(String.format("Error: Kubernetes config %1s could not be processed.", path), (Throwable)e);
        }
    }

    private Config withCustomSettings(Config config) {
        config.setRequestTimeout(this.requestTimeoutInMs);
        config.setConnectionTimeout(this.connectionTimeoutMs);
        return config;
    }

    @Bean
    public KubernetesClient kubernetesClient() throws CouldNotConstructKubernetesClientException {
        KubernetesClient client;
        if (!StringUtils.isBlank((CharSequence)this.roverToken)) {
            client = this.createClientFromRoverToken(this.roverToken);
            log.info("Using configured rover token for configuring the Kubernetes client");
        } else if (!StringUtils.isBlank((CharSequence)this.kubeConfigPath)) {
            client = this.createClientFromeKubeconfigFile(this.kubeConfigPath);
            log.info("Using configured Kubernetes config file ({}) for configuring the Kubernetes client", (Object)this.kubeConfigPath);
        } else if ("dev".equals(this.activeProfile) || "test".equals(this.activeProfile)) {
            client = this.createClientFromBundledConfig();
            log.info("Using bundled Kubernetes dev config");
        } else {
            Config config = new ConfigBuilder().build();
            client = new DefaultKubernetesClient(this.withCustomSettings(config));
            log.info("Using default Kubernetes config");
        }
        log.info("Using cluster {}", (Object)client.getConfiguration().getMasterUrl());
        SimpleModule operatorModule = new SimpleModule();
        operatorModule.addDeserializer(Operator.class, (JsonDeserializer)new OperatorDeserializer());
        operatorModule.addSerializer(Operator.class, (JsonSerializer)new OperatorSerializer());
        Serialization.jsonMapper().registerModule((Module)operatorModule);
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={SubscriptionResource.class}, parameterizedContainer={ResourceEventHandler.class})
    public ResourceEventHandler<SubscriptionResource> defaultEventHandler() {
        return new ResourceEventHandler<SubscriptionResource>(this){

            public void onAdd(SubscriptionResource obj) {
                log.warn("This is the default SubscriptionResource ResourceEventHandler!");
            }

            public void onUpdate(SubscriptionResource oldObj, SubscriptionResource newObj) {
                log.warn("This is the default SubscriptionResource ResourceEventHandler!");
            }

            public void onDelete(SubscriptionResource obj, boolean deletedFinalStateUnknown) {
                log.warn("This is the default SubscriptionResource ResourceEventHandler!");
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={Pod.class}, parameterizedContainer={ResourceEventHandler.class})
    public ResourceEventHandler<Pod> defaultPodEventHandler() {
        return new ResourceEventHandler<Pod>(this){

            public void onAdd(Pod obj) {
                log.warn("This is the default Pod ResourceEventHandler!");
            }

            public void onUpdate(Pod oldObj, Pod newObj) {
                log.warn("This is the default Pod ResourceEventHandler!");
            }

            public void onDelete(Pod obj, boolean deletedFinalStateUnknown) {
                log.warn("This is the default Pod ResourceEventHandler!");
            }
        };
    }

    @Bean
    public InformerStoreInitHandler cacheInitHandler(KubernetesClient kubernetesClient) {
        return new InformerStoreInitHandler(new KubernetesClientWrapper(kubernetesClient));
    }

    @Bean
    public PodResourceListener podResourceListener(KubernetesClient kubernetesClient, ResourceEventHandler<Pod> podEventHandler) {
        PodResourceListener listener = new PodResourceListener(kubernetesClient, podEventHandler, this.resyncPeriodInMs, this.podsNamespace, this.appName);
        listener.init();
        return listener;
    }
}

