/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.eni.pandora.horizon.autoconfigure.cache;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.core.HazelcastInstance;
import de.telekom.eni.pandora.horizon.cache.config.CacheProperties;
import de.telekom.eni.pandora.horizon.cache.service.CacheService;
import de.telekom.eni.pandora.horizon.cache.service.DeDuplicationService;
import jakarta.annotation.PreDestroy;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(value={"horizon.cache.enabled"})
@Import(value={HazelcastAutoConfiguration.class})
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CacheAutoConfiguration.class);
    private static final String DEFAULT_HAZELCAST_CLUSTER_NAME = "dev";
    private HazelcastInstance hazelcastInstance;
    @Value(value="${POD_NAME:horizon}")
    private String podName;

    @PreDestroy
    public void shutdown() {
        log.info("Shutdown hazelcast client");
        HazelcastClient.shutdown((HazelcastInstance)this.hazelcastInstance);
    }

    @Primary
    @Bean
    public HazelcastInstance hazelcastInstance(CacheProperties cacheProperties) {
        log.info("Initializing new hazelcast client");
        ClientConfig config = new ClientConfig();
        config.setClusterName(DEFAULT_HAZELCAST_CLUSTER_NAME);
        if (cacheProperties != null && StringUtils.isNotBlank((CharSequence)cacheProperties.getKubernetesServiceDns())) {
            config.getNetworkConfig().addAddress(new String[]{cacheProperties.getKubernetesServiceDns()});
        } else {
            config.getNetworkConfig().addAddress(new String[]{"localhost:5701"});
        }
        if ("horizon".equals(this.podName)) {
            this.podName = "horizon-" + UUID.randomUUID().toString();
        }
        config.setInstanceName(this.podName);
        config.getNetworkConfig().setConnectionTimeout(5000);
        config.getConnectionStrategyConfig().setAsyncStart(true).setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        config.setProperty("hazelcast.client.heartbeat.interval", "1000");
        config.setProperty("hazelcast.client.heartbeat.timeout", "5000");
        ConnectionRetryConfig retryConfig = config.getConnectionStrategyConfig().getConnectionRetryConfig();
        retryConfig.setInitialBackoffMillis(1000).setMaxBackoffMillis(1000).setMultiplier(1.0).setClusterConnectTimeoutMillis(-1L);
        log.debug("Hazelcast client config: {}", (Object)config);
        this.hazelcastInstance = HazelcastClient.newHazelcastClient((ClientConfig)config);
        return this.hazelcastInstance;
    }

    @Bean
    public CacheService cacheService(HazelcastInstance hazelcastInstance, CacheProperties cacheProperties) {
        return new CacheService(hazelcastInstance, cacheProperties);
    }

    @Bean
    public DeDuplicationService deDuplicationService(HazelcastInstance hazelcastInstance, CacheProperties cacheProperties) {
        return new DeDuplicationService(hazelcastInstance, cacheProperties);
    }
}

