/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.eni.pandora.horizon.autoconfigure.cache;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.MapListener;
import de.telekom.eni.pandora.horizon.cache.fallback.JsonCacheFallback;
import de.telekom.eni.pandora.horizon.cache.fallback.SubscriptionCacheMongoFallback;
import de.telekom.eni.pandora.horizon.cache.listener.AbstractHazelcastJsonEntryMapEventBroadcaster;
import de.telekom.eni.pandora.horizon.cache.listener.SubscriptionResourceEventBroadcaster;
import de.telekom.eni.pandora.horizon.cache.service.JsonCacheService;
import de.telekom.eni.pandora.horizon.kubernetes.resource.SubscriptionResource;
import de.telekom.eni.pandora.horizon.model.meta.CircuitBreakerMessage;
import de.telekom.eni.pandora.horizon.mongo.config.MongoProperties;
import de.telekom.eni.pandora.horizon.mongo.repository.SubscriptionsMongoRepo;
import de.telekom.jsonfilter.operator.Operator;
import de.telekom.jsonfilter.serde.OperatorDeserializer;
import de.telekom.jsonfilter.serde.OperatorSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"horizon.cache.enabled"})
public class JsonCacheAutoconfiguration {
    private static final Logger log = LoggerFactory.getLogger(JsonCacheAutoconfiguration.class);
    private static final String SUBSCRIPTION_RESOURCE_V1 = "subscriptions.subscriber.horizon.telekom.de.v1";
    private static final String CIRCUITBREAKER_MAP = "circuit-breakers";
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    @Bean
    public JsonCacheService<SubscriptionResource> subscriptionCache(HazelcastInstance hazelcastInstance, ApplicationEventPublisher applicationEventPublisher, SubscriptionsMongoRepo subscriptionsMongoRepo, MongoProperties mongoProperties) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Operator.class, (JsonSerializer)new OperatorSerializer());
        module.addDeserializer(Operator.class, (JsonDeserializer)new OperatorDeserializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        IMap map = null;
        try {
            map = hazelcastInstance.getMap(SUBSCRIPTION_RESOURCE_V1);
            map.addEntryListener((MapListener)new SubscriptionResourceEventBroadcaster(mapper, applicationEventPublisher), true);
        }
        catch (Exception e) {
            log.error("Hazelcast map {} is not available", (Object)SUBSCRIPTION_RESOURCE_V1);
        }
        JsonCacheService svc = new JsonCacheService(SubscriptionResource.class, map, mapper, hazelcastInstance, SUBSCRIPTION_RESOURCE_V1);
        svc.setJsonCacheFallback((JsonCacheFallback)new SubscriptionCacheMongoFallback(subscriptionsMongoRepo, mongoProperties));
        svc.setJsonEntryMapEventBroadcaster((AbstractHazelcastJsonEntryMapEventBroadcaster)new SubscriptionResourceEventBroadcaster(mapper, applicationEventPublisher));
        return svc;
    }

    @Bean
    public JsonCacheService<CircuitBreakerMessage> circuitBreakerCache(HazelcastInstance hazelcastInstance) {
        IMap map = null;
        try {
            map = hazelcastInstance.getMap(CIRCUITBREAKER_MAP);
        }
        catch (Exception e) {
            log.error("Hazelcast map {} is not available", (Object)CIRCUITBREAKER_MAP);
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        return new JsonCacheService(CircuitBreakerMessage.class, map, mapper, hazelcastInstance, CIRCUITBREAKER_MAP);
    }
}

