/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.eni.pandora.horizon.autoconfigure.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import de.telekom.eni.pandora.horizon.mongo.config.MongoProperties;
import de.telekom.eni.pandora.horizon.mongo.repository.MessageStateMongoRepo;
import de.telekom.eni.pandora.horizon.mongo.repository.SubscriptionsMongoRepo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.retry.annotation.EnableRetry;

@Configuration
@ConditionalOnProperty(value={"horizon.mongo.enabled"})
@EnableRetry
@EnableConfigurationProperties(value={MongoProperties.class})
public class MongoAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MongoAutoConfiguration.class);
    @Value(value="${spring.application.name:horizon-parent}")
    private String applicationName;

    @Bean
    public MongoClient mongoClient(MongoProperties properties) {
        log.debug("Using status database: " + properties.getDatabases().getRunTimeDatabase());
        log.debug("Using config database: " + properties.getDatabases().getConfigTimeDatabase());
        ConnectionString connectionString = new ConnectionString(properties.getUrl());
        MongoClientSettings clientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).writeConcern(properties.getWriteConcern()).applicationName(this.applicationName).build();
        return MongoClients.create((MongoClientSettings)clientSettings);
    }

    @Bean(name={"mongoStatusTemplate"})
    public MongoTemplate mongoStatusTemplate(MongoClient mongoClient, MongoProperties properties) {
        return new MongoTemplate(mongoClient, properties.getDatabases().getRunTimeDatabase());
    }

    @Primary
    @Bean(name={"mongoConfigTemplate"})
    public MongoTemplate mongoConfigTemplate(MongoClient mongoClient, MongoProperties properties) {
        return new MongoTemplate(mongoClient, properties.getDatabases().getConfigTimeDatabase());
    }

    @Bean
    public MessageStateMongoRepo getStatusMessageRepo(@Qualifier(value="mongoStatusTemplate") MongoTemplate mongoStatusTemplate) {
        MongoRepositoryFactory mongoRepositoryFactory = new MongoRepositoryFactory((MongoOperations)mongoStatusTemplate);
        return (MessageStateMongoRepo)mongoRepositoryFactory.getRepository(MessageStateMongoRepo.class);
    }

    @Bean
    public SubscriptionsMongoRepo getSubscriptionsRepo(@Qualifier(value="mongoConfigTemplate") MongoTemplate mongoConfigTemplate) {
        MongoRepositoryFactory mongoRepositoryFactory = new MongoRepositoryFactory((MongoOperations)mongoConfigTemplate);
        return (SubscriptionsMongoRepo)mongoRepositoryFactory.getRepository(SubscriptionsMongoRepo.class);
    }
}

