/*
 * Decompiled with CFR 0.152.
 */
package de.telekom.eni.pandora.horizon.autoconfigure.tracing;

import brave.Tracer;
import brave.Tracing;
import brave.TracingCustomizer;
import de.telekom.eni.pandora.horizon.tracing.HorizonTracer;
import de.telekom.eni.pandora.horizon.tracing.PandoraTracer;
import de.telekom.eni.pandora.horizon.tracing.TracingProperties;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.tracing.BraveAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@EnableConfigurationProperties(value={org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties.class, TracingProperties.class})
@Import(value={BraveAutoConfiguration.class})
public class HorizonTracerAutoConfiguration {
    @ConditionalOnClass(value={KafkaTemplate.class})
    @Bean
    public HorizonTracer pandoraHorizonTracer(TracingProperties tracingProperties, Environment environment, Tracing tracing, Tracer tracer) {
        return new HorizonTracer(environment, tracing, tracer, tracingProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"pandora.tracing.name"})
    TracingCustomizer tracingServiceNameCustomizer(@Value(value="${pandora.tracing.name:unsetLocalServiceName}") String tracingName) {
        return builder -> builder.localServiceName(tracingName);
    }

    @Bean
    public Filter traceInformationResponseFilter(PandoraTracer tracer) {
        return tracer.createTraceInformationResponseFilter();
    }
}

