/*
 * Decompiled with CFR 0.152.
 */
package de.theappguys.winzigsql;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import de.theappguys.winzigsql.UriUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class Cruddable
implements Serializable {
    public static final String ID = "_id";
    protected final ArrayList<CrudValue<?>> values;
    public final CrudNullableLong _id;
    private final String tableName;
    private final String authority;

    public Cruddable(String tableName, String authority, int valueCount) {
        this.values = new ArrayList(valueCount + 1);
        this._id = new CrudNullableLong(ID);
        this.tableName = tableName;
        this.authority = authority;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Uri getBaseUri() {
        return UriUtils.contentUri(this.authority, this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(ContentResolver resolver, long _id) {
        Cursor cursor = resolver.query(UriUtils.appendToUri(this.getBaseUri(), _id), this.getProjection(), null, null, null);
        try {
            if (cursor.getCount() != 1) {
                throw new IllegalArgumentException("Expected exactly one result for id " + _id + ", got " + cursor.getCount());
            }
            if (cursor.isBeforeFirst()) {
                cursor.moveToNext();
            }
            this.fromCursor(cursor);
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(SQLiteDatabase db, long _id) {
        Cursor cursor = db.query("", this.getProjection(), "WHERE _id = ?", new String[]{Long.toString(_id)}, "", "", "");
        try {
            cursor.moveToFirst();
            this.fromCursor(cursor);
        }
        finally {
            cursor.close();
        }
    }

    public void fromCursor(Cursor cursor) {
        for (CrudValue<?> val : this.values) {
            val.fromCursor(cursor);
        }
    }

    public void fromCursor(int offset, Cursor cursor) {
        for (CrudValue<?> val : this.values) {
            val.fromCursor(offset, cursor);
        }
    }

    public static void fromCursor(Cursor cursor, Cruddable ... cruddables) {
        Cruddable.fromCursor(0, cursor, cruddables);
    }

    public static void fromCursor(int offset, Cursor cursor, Cruddable ... cruddables) {
        int fieldCount = offset;
        for (Cruddable cruddable : cruddables) {
            cruddable.fromCursor(fieldCount, cursor);
            fieldCount += cruddable.getProjectionLength();
        }
    }

    public Long create(ContentResolver resolver) {
        Uri uri = resolver.insert(this.getBaseUri(), this.toContentValues());
        try {
            List segments = uri.getPathSegments();
            this._id.set(Long.parseLong((String)segments.get(segments.size() - 1)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not read id from uri: " + uri);
        }
        return (Long)this._id.get();
    }

    public Long create(SQLiteDatabase db) {
        return db.insert(this.tableName, null, this.toContentValues());
    }

    public void update(ContentResolver resolver) {
        if (this._id.isNull()) {
            throw new IllegalStateException("Cannot update " + this + ", id is null.");
        }
        int count = resolver.update(UriUtils.appendToUri(this.getBaseUri(), this._id.get()), this.toContentValues(), null, null);
        if (count != 1) {
            throw new IllegalStateException("Update of " + this + "" + " failed, expected one update, got: " + count);
        }
    }

    public void update(SQLiteDatabase db) {
        if (this._id.isNull()) {
            throw new IllegalStateException("Cannot update " + this + ", id is null.");
        }
        int count = db.update(this.tableName, this.toContentValues(), "WHERE _id=?", new String[]{((Long)this._id.get()).toString()});
        if (count != 1) {
            throw new IllegalStateException("Update of " + this + "" + " failed, expected one update, got: " + count);
        }
    }

    public void createOrUpdate(ContentResolver resolver) {
        if (this._id.isNull()) {
            this.create(resolver);
        } else {
            this.update(resolver);
        }
    }

    public void createOrUpdate(SQLiteDatabase db) {
        if (this._id.isNull()) {
            this.create(db);
        } else {
            this.update(db);
        }
    }

    public void delete(ContentResolver resolver) {
        if (this._id.isNull()) {
            throw new IllegalStateException("Cannot delete " + this + ", id is null.");
        }
        resolver.delete(UriUtils.appendToUri(this.getBaseUri(), this._id.get()), null, null);
    }

    public void delete(SQLiteDatabase db) {
        if (this._id.isNull()) {
            throw new IllegalStateException("Cannot delete " + this + ", id is null.");
        }
        db.delete(this.tableName, "WHERE _id=?", new String[]{((Long)this._id.get()).toString()});
    }

    public String[] getProjection() {
        String[] projection = new String[this.values.size()];
        for (int n = 0; n < projection.length; ++n) {
            projection[n] = this.values.get((int)n).dbFieldName;
        }
        return projection;
    }

    public String[] getProjection(String tablePrefix) {
        String[] projection = new String[this.values.size()];
        for (int n = 0; n < projection.length; ++n) {
            projection[n] = tablePrefix + "." + this.values.get((int)n).dbFieldName;
        }
        return projection;
    }

    public int getProjectionLength() {
        return this.values.size();
    }

    public static String[] combineProjections(String[] ... projections) {
        int length = 0;
        for (String[] projection : projections) {
            length += projection.length;
        }
        String[] result = new String[length];
        int idx = 0;
        for (String[] projection : projections) {
            System.arraycopy(projection, 0, result, idx, projection.length);
            idx += projection.length;
        }
        return result;
    }

    public ContentValues toContentValues() {
        ContentValues result = new ContentValues(this.values.size());
        for (int n = 0; n < this.values.size(); ++n) {
            this.values.get(n).addToContentValues(result);
        }
        return result;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Cruddable that = (Cruddable)other;
        return this.values.equals(that.values);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + TextUtils.join((CharSequence)", ", this.values) + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableEnum<T extends Enum<T>>
    extends CrudNullableValue<T> {
        private final Class<T> clazz;

        public CrudNullableEnum(String dbFieldName, Class<T> clazz) {
            super(dbFieldName);
            this.clazz = clazz;
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : Enum.valueOf(this.clazz, cursor.getString(offset + this.index));
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, this.t == null ? null : ((Enum)this.t).name());
        }

        @Override
        public void parse(String s) {
            this.t = s == null ? null : Enum.valueOf(this.clazz, s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableDate
    extends CrudNullableValue<Date> {
        public CrudNullableDate(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : new Date(cursor.getLong(offset + this.index));
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, this.t == null ? null : Long.valueOf(((Date)this.t).getTime()));
        }

        @Override
        public void parse(String s) {
            throw new NoSuchMethodError("TODO: proper iso ISO8601 date parsing not implemented.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableBlob
    extends CrudNullableValue<byte[]> {
        public CrudNullableBlob(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : cursor.getBlob(offset + this.index);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, (byte[])this.t);
        }

        @Override
        public void parse(String s) {
            this.t = s == null ? null : (Object)Base64.decode((String)s, (int)0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableDouble
    extends CrudNullableValue<Double> {
        public CrudNullableDouble(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : Double.valueOf(cursor.getDouble(offset + this.index));
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, (Double)this.t);
        }

        @Override
        public void parse(String s) {
            this.t = s == null ? null : Double.valueOf(Double.parseDouble(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableFloat
    extends CrudNullableValue<Float> {
        public CrudNullableFloat(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : Float.valueOf(cursor.getFloat(offset + this.index));
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, (Float)this.t);
        }

        @Override
        public void parse(String s) {
            this.t = s == null ? null : Float.valueOf(Float.parseFloat(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableString
    extends CrudNullableValue<String> {
        public CrudNullableString(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : cursor.getString(offset + this.index);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, (String)this.t);
        }

        @Override
        public void parse(String s) {
            this.t = s == null ? null : s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableLong
    extends CrudNullableValue<Long> {
        public CrudNullableLong(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : Long.valueOf(cursor.getLong(offset + this.index));
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, (Long)this.t);
        }

        @Override
        public void parse(String s) {
            this.t = s == null ? null : Long.valueOf(Long.parseLong(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableInteger
    extends CrudNullableValue<Integer> {
        public CrudNullableInteger(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : Integer.valueOf(cursor.getInt(offset + this.index));
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, (Integer)this.t);
        }

        @Override
        public void parse(String s) {
            this.t = s == null ? null : Integer.valueOf(Integer.parseInt(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableShort
    extends CrudNullableValue<Short> {
        public CrudNullableShort(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : Short.valueOf(cursor.getShort(offset + this.index));
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, (Short)this.t);
        }

        @Override
        public void parse(String s) {
            this.t = s == null ? null : Short.valueOf(Short.parseShort(s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudNullableBoolean
    extends CrudNullableValue<Boolean> {
        public CrudNullableBoolean(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.isNull(offset + this.index) ? null : Boolean.valueOf(cursor.getInt(offset + this.index) != 0);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, this.t == null ? null : Integer.valueOf((Boolean)this.t != false ? 1 : 0));
        }

        @Override
        public void parse(String s) {
            if (s == null) {
                this.t = null;
                return;
            }
            String lower = s.toLowerCase();
            if ("true".equals(lower) || "1".equals(lower)) {
                this.t = true;
            } else if ("false".equals(lower) || "0".equals(lower)) {
                this.t = false;
            } else {
                throw new IllegalArgumentException("Not a valid boolean literal: '" + s + "', must be 'true', 'false', '0' or '1' (case-insensitive).");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudEnum<T extends Enum<T>>
    extends CrudNotNullableObjectValue<T> {
        private final Class<T> clazz;

        public CrudEnum(String dbFieldName, Class<T> clazz) {
            super(dbFieldName);
            this.clazz = clazz;
            this.t = ((Enum[])clazz.getEnumConstants())[0];
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            if (cursor.isNull(offset + this.index)) {
                throw new NullPointerException("Value for " + this.getClass().getSimpleName() + " at cursor index " + (offset + this.index) + " is null.");
            }
            this.t = Enum.valueOf(this.clazz, cursor.getString(offset + this.index));
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, ((Enum)this.t).name());
        }

        @Override
        public void parse(String s) {
            this.t = Enum.valueOf(this.clazz, s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudDate
    extends CrudNotNullableObjectValue<Date> {
        public CrudDate(String dbFieldName) {
            super(dbFieldName);
            this.t = new Date();
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            if (cursor.isNull(offset + this.index)) {
                throw new NullPointerException("Value for " + this.getClass().getSimpleName() + " at cursor index " + (offset + this.index) + " is null.");
            }
            this.t = new Date(cursor.getLong(offset + this.index));
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, Long.valueOf(((Date)this.t).getTime()));
        }

        @Override
        public void parse(String s) {
            throw new NoSuchMethodError("TODO: proper iso ISO8601 date parsing not implemented.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudBlob
    extends CrudNotNullableObjectValue<byte[]> {
        public CrudBlob(String dbFieldName) {
            super(dbFieldName);
            this.t = new byte[0];
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            if (cursor.isNull(offset + this.index)) {
                throw new NullPointerException("Value for " + this.getClass().getSimpleName() + " at cursor index " + (offset + this.index) + " is null.");
            }
            this.t = cursor.getBlob(offset + this.index);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, (byte[])this.t);
        }

        @Override
        public void parse(String s) {
            this.t = Base64.decode((String)s, (int)0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudDouble
    extends CrudNotNullableValue<Double> {
        private double t;

        public CrudDouble(String dbFieldName) {
            super(dbFieldName);
            this.t = 0.0;
        }

        @Override
        public Double get() {
            return this.t;
        }

        public double getDouble() {
            return this.t;
        }

        @Override
        public void set(Double t) {
            this.t = t;
        }

        @Override
        public void parse(String s) {
            this.t = Double.parseDouble(s);
        }

        public void setDouble(double t) {
            this.t = t;
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.getDouble(offset + this.index);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, Double.valueOf(this.t));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudFloat
    extends CrudNotNullableValue<Float> {
        private float t;

        public CrudFloat(String dbFieldName) {
            super(dbFieldName);
            this.t = 0.0f;
        }

        @Override
        public Float get() {
            return Float.valueOf(this.t);
        }

        public float getFloat() {
            return this.t;
        }

        @Override
        public void set(Float t) {
            this.t = t.floatValue();
        }

        @Override
        public void parse(String s) {
            this.t = Float.parseFloat(s);
        }

        public void setFloat(float t) {
            this.t = t;
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.getFloat(offset + this.index);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, Float.valueOf(this.t));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudString
    extends CrudNotNullableObjectValue<String> {
        public CrudString(String dbFieldName) {
            super(dbFieldName);
            this.t = "";
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            if (cursor.isNull(this.index + offset)) {
                throw new NullPointerException("Value for " + this.getClass().getSimpleName() + " at cursor index " + this.index + " is null.");
            }
            this.t = cursor.getString(this.index + offset);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, (String)this.t);
        }

        @Override
        public void parse(String s) {
            this.set(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudLong
    extends CrudNotNullableValue<Long> {
        private long t;

        public CrudLong(String dbFieldName) {
            super(dbFieldName);
            this.t = 0L;
        }

        @Override
        public Long get() {
            return this.t;
        }

        public long getLong() {
            return this.t;
        }

        @Override
        public void set(Long t) {
            this.t = t;
        }

        @Override
        public void parse(String s) {
            this.t = Long.parseLong(s);
        }

        public void setLong(long t) {
            this.t = t;
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.getLong(offset + this.index);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, Long.valueOf(this.t));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudInteger
    extends CrudNotNullableValue<Integer> {
        private int t;

        public CrudInteger(String dbFieldName) {
            super(dbFieldName);
            this.t = 0;
        }

        @Override
        public Integer get() {
            return this.t;
        }

        public int getInt() {
            return this.t;
        }

        @Override
        public void set(Integer t) {
            this.t = t;
        }

        @Override
        public void parse(String s) {
            this.t = Integer.parseInt(s);
        }

        public void setInt(int t) {
            this.t = t;
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.getInt(offset + this.index);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, Integer.valueOf(this.t));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudShort
    extends CrudNotNullableValue<Short> {
        private short t;

        public CrudShort(String dbFieldName) {
            super(dbFieldName);
            this.t = 0;
        }

        @Override
        public Short get() {
            return this.t;
        }

        public short getShort() {
            return this.t;
        }

        @Override
        public void set(Short t) {
            this.t = t;
        }

        @Override
        public void parse(String s) {
            this.t = Short.parseShort(s);
        }

        public void setShort(short t) {
            this.t = t;
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.getShort(offset + this.index);
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, Short.valueOf(this.t));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CrudBoolean
    extends CrudNotNullableValue<Boolean> {
        private boolean t;

        public CrudBoolean(String dbFieldName) {
            super(dbFieldName);
            this.t = false;
        }

        @Override
        public Boolean get() {
            return this.t;
        }

        public boolean getBoolean() {
            return this.t;
        }

        @Override
        public void set(Boolean t) {
            this.t = t;
        }

        @Override
        public void parse(String s) {
            String lower = s.toLowerCase();
            if ("true".equals(lower) || "1".equals(lower)) {
                this.t = true;
            } else if ("false".equals(lower) || "0".equals(lower)) {
                this.t = false;
            } else {
                throw new IllegalArgumentException("Not a valid boolean literal: '" + s + "', must be 'true', 'false', '0' or '1' (case-insensitive).");
            }
        }

        public void setBoolean(boolean t) {
            this.t = t;
        }

        @Override
        protected void fromCursor(int offset, Cursor cursor) {
            this.t = cursor.getInt(offset + this.index) != 0;
        }

        @Override
        protected void addToContentValues(ContentValues values) {
            values.put(this.dbFieldName, Integer.valueOf(this.t ? 1 : 0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CrudNotNullableObjectValue<T>
    extends CrudNotNullableValue<T> {
        protected T t;

        public CrudNotNullableObjectValue(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        public T get() {
            return this.t;
        }

        @Override
        public void set(T t) {
            if (t == null) {
                throw new NullPointerException("Attempt to set null on " + this.getClass().getSimpleName());
            }
            this.t = t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CrudNotNullableValue<T>
    extends CrudValue<T> {
        public CrudNotNullableValue(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CrudNullableValue<T>
    extends CrudValue<T> {
        protected T t;

        public CrudNullableValue(String dbFieldName) {
            super(dbFieldName);
        }

        @Override
        public boolean isNullable() {
            return true;
        }

        @Override
        public void set(T t) {
            this.t = t;
        }

        @Override
        public boolean isNull() {
            return this.t == null;
        }

        @Override
        public T get() {
            return this.t;
        }

        public T get(T def) {
            T t = this.get();
            if (t == null) {
                return def;
            }
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CrudValue<T>
    implements Serializable {
        protected final int index;
        protected final String dbFieldName;

        public CrudValue(String dbFieldName) {
            this.dbFieldName = dbFieldName;
            this.index = Cruddable.this.values.size();
            Cruddable.this.values.add(this);
        }

        public String getFieldName() {
            return this.dbFieldName;
        }

        public abstract void set(T var1);

        public abstract void parse(String var1);

        public abstract T get();

        public abstract boolean isNullable();

        public abstract boolean isNull();

        protected void fromCursor(Cursor cursor) {
            this.fromCursor(0, cursor);
        }

        protected abstract void fromCursor(int var1, Cursor var2);

        protected abstract void addToContentValues(ContentValues var1);

        public int hashCode() {
            if (this.isNull()) {
                return 0;
            }
            return this.get().hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            CrudValue that = (CrudValue)other;
            if (this.isNull()) {
                return that.isNull();
            }
            return this.get().equals(that.get());
        }

        public String toString() {
            return this.dbFieldName + "=" + this.get();
        }
    }
}

