/*
 * Decompiled with CFR 0.152.
 */
package de.theappguys.winzigsql;

import android.content.Context;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class ResourceUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final int CHAR_BUFFER_SIZE = 2048;
    public static final int BYTE_BUFFER_SIZE = 4096;

    private ResourceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readRawResourceAsString(Context ctx, int id) throws IOException {
        InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(ctx.getResources().openRawResource(id)), UTF_8);
        try {
            String string = ResourceUtils.readString(r);
            return string;
        }
        finally {
            ((Reader)r).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAssetAsString(Context ctx, String name) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(ctx.getAssets().open(name), UTF_8));
        try {
            String string = ResourceUtils.readString(r);
            return string;
        }
        finally {
            ((Reader)r).close();
        }
    }

    public static String readString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        ResourceUtils.copy(in, out);
        return out.toString();
    }

    public static void copy(Reader in, Writer out) throws IOException {
        char[] buffer = new char[2048];
        int read = 0;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int read = 0;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }
}

