/*
 * Decompiled with CFR 0.152.
 */
package de.theappguys.winzigsql;

import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUtils {
    private SqlUtils() {
    }

    public static List<String> parseSqlScript(String script) {
        StringBuilder withoutBlockComments = new StringBuilder();
        boolean inBlock = false;
        int length = script.length();
        int lastN = length - 1;
        for (int n = 0; n < length; ++n) {
            char next;
            char current = script.charAt(n);
            char c = next = n < lastN ? script.charAt(n + 1) : (char)'\u0000';
            if (inBlock) {
                if (current != '*' || next != '/') continue;
                inBlock = false;
                ++n;
                continue;
            }
            if (current == '/' && next == '*') {
                inBlock = true;
                ++n;
                continue;
            }
            withoutBlockComments.append(current);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentStatement = new StringBuilder();
        for (String maybeWindowsLine : TextUtils.split((String)withoutBlockComments.toString(), (String)"\n")) {
            String lineRest;
            String line = maybeWindowsLine.endsWith("\r") ? maybeWindowsLine.substring(0, maybeWindowsLine.length() - 1) : maybeWindowsLine;
            int idx = line.indexOf("--");
            String string = lineRest = idx == -1 ? line.trim() : line.substring(0, idx).trim();
            if (lineRest.length() <= 0) continue;
            currentStatement.append(lineRest).append('\n');
            if (lineRest.charAt(lineRest.length() - 1) != ';') continue;
            result.add(currentStatement.toString());
            currentStatement.setLength(0);
        }
        return result;
    }

    public static void executeStatements(SQLiteDatabase db, String sqlStatements) {
        SqlUtils.executeStatements(db, SqlUtils.parseSqlScript(sqlStatements));
    }

    public static void executeStatements(SQLiteDatabase db, Iterable<String> sqlStatements) {
        for (String statement : sqlStatements) {
            if (TextUtils.isEmpty((CharSequence)statement)) continue;
            db.execSQL(statement);
        }
    }
}

