/*
 * Decompiled with CFR 0.152.
 */
package de.theappguys.winzigsql;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import de.theappguys.winzigsql.ResourceUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WinzigDbFileHelper
extends SQLiteOpenHelper {
    public static final String LOG_TAG = "winzigsql";
    private final Context context;
    private final String dbName;
    private final File dbFile;

    public WinzigDbFileHelper(Context context, String dbName, int dbVersion) {
        super(context, dbName, null, dbVersion);
        this.dbName = dbName;
        this.context = context.getApplicationContext();
        this.dbFile = context.getDatabasePath(dbName);
    }

    public SQLiteDatabase getReadableDatabase() {
        if (!this.dbExists()) {
            this.copyDb();
        }
        return super.getReadableDatabase();
    }

    public SQLiteDatabase getWritableDatabase() {
        if (!this.dbExists()) {
            this.copyDb();
        }
        return super.getWritableDatabase();
    }

    public void onCreate(SQLiteDatabase db) {
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.close();
        this.copyDb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDb() {
        String assetName = this.dbName + ".sqlite";
        this.dbFile.getParentFile().mkdirs();
        Log.d((String)LOG_TAG, (String)("Copying db '" + assetName + "'"));
        try {
            InputStream in = this.context.getAssets().open(assetName);
            try {
                FileOutputStream out = new FileOutputStream(this.dbFile);
                try {
                    ResourceUtils.copy(in, out);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)("Could not copy db '" + this.dbName + "' from asset '" + assetName + "' to file '" + this.dbFile + "'"), (Throwable)e);
            throw new SQLiteException("Could not copy db '" + this.dbName + "' from asset '" + assetName + "' to file '" + this.dbFile + "', " + e.getMessage());
        }
    }

    protected boolean dbExists() {
        return this.dbFile.isFile();
    }

    public boolean dropDb() {
        return this.context.deleteDatabase(this.dbName);
    }
}

