/*
 * Decompiled with CFR 0.152.
 */
package de.theappguys.winzigsql;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import de.theappguys.winzigsql.UriUtils;
import java.util.List;

public abstract class WinzigDbProvider
extends ContentProvider {
    private final String authority;
    private SQLiteOpenHelper db;
    private final Uri baseUri;

    public static Uri createBaseUri(String authority) {
        return UriUtils.contentUri(authority, new Object[0]);
    }

    public WinzigDbProvider(String authority) {
        this.authority = authority;
        this.baseUri = WinzigDbProvider.createBaseUri(authority);
    }

    protected abstract SQLiteOpenHelper createDb(Context var1);

    public Uri getBaseUriForDatabase() {
        return this.baseUri;
    }

    public Uri getBaseUriForTable(String table) {
        return Uri.withAppendedPath((Uri)this.baseUri, (String)table);
    }

    public boolean onCreate() {
        this.db = this.createDb(this.getContext());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor cursor;
        UriParseResult parsedUri = new UriParseResult(uri);
        if ("".equals(parsedUri.tables)) {
            cursor = this.db.getReadableDatabase().rawQuery(selection, selectionArgs);
        } else if (parsedUri.id != null) {
            SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
            queryBuilder.setTables(parsedUri.tables);
            cursor = queryBuilder.query(this.db.getReadableDatabase(), projection, "_id = " + parsedUri.id, selectionArgs, null, null, sortOrder);
        } else {
            SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
            queryBuilder.setTables(parsedUri.tables);
            cursor = queryBuilder.query(this.db.getReadableDatabase(), projection, selection, selectionArgs, null, null, sortOrder);
        }
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    public Uri insert(Uri uri, ContentValues values) {
        UriParseResult parsedUri = new UriParseResult(uri);
        if ("".equals(parsedUri.tables)) {
            throw new IllegalArgumentException("Cannot insert, no table provided: '" + uri.toString() + "'");
        }
        if (parsedUri.id != null) {
            throw new IllegalArgumentException("Cannot insert, insert uri contains id: '" + uri.toString() + "'");
        }
        long id = this.db.getWritableDatabase().insert(parsedUri.tables, null, values);
        this.getContext().getContentResolver().notifyChange(uri, null);
        return Uri.withAppendedPath((Uri)uri, (String)Long.toString(id));
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        UriParseResult parsedUri = new UriParseResult(uri);
        if ("".equals(parsedUri.tables)) {
            throw new IllegalArgumentException("Cannot delete, no table provided: '" + uri.toString() + "'");
        }
        int count = parsedUri.id != null ? this.db.getWritableDatabase().delete(parsedUri.tables, "_id = ?", new String[]{Long.toString(parsedUri.id)}) : this.db.getWritableDatabase().delete(parsedUri.tables, selection, selectionArgs);
        this.getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        UriParseResult parsedUri = new UriParseResult(uri);
        if ("".equals(parsedUri.tables)) {
            throw new IllegalArgumentException("Cannot update, no table provided: '" + uri.toString() + "'");
        }
        int count = parsedUri.id != null ? this.db.getWritableDatabase().update(parsedUri.tables, values, "_id = ?", new String[]{Long.toString(parsedUri.id)}) : this.db.getWritableDatabase().update(parsedUri.tables, values, selection, selectionArgs);
        this.getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    public String getType(Uri uri) {
        return null;
    }

    private class UriParseResult {
        final String tables;
        final Long id;

        public UriParseResult(Uri uri) {
            if (!WinzigDbProvider.this.authority.equals(uri.getEncodedAuthority())) {
                throw new IllegalArgumentException("Expected authority: '" + WinzigDbProvider.this.authority + "' got '" + uri.getEncodedAuthority() + "'.");
            }
            List pathSegments = uri.getPathSegments();
            if (pathSegments.size() > 2) {
                throw new IllegalArgumentException("Uri path to long: '" + uri);
            }
            String string = this.tables = !pathSegments.isEmpty() ? (String)pathSegments.get(0) : "";
            if (pathSegments.size() == 2) {
                try {
                    this.id = Long.parseLong((String)pathSegments.get(1));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Not a valid id: " + (String)pathSegments.get(1), e);
                }
            } else {
                this.id = null;
            }
        }
    }
}

