/*
 * Decompiled with CFR 0.152.
 */
package de.theappguys.winzigsql;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import de.theappguys.winzigsql.ResourceUtils;
import de.theappguys.winzigsql.SqlUtils;
import java.io.IOException;

public class WinzigDbScriptHelper
extends SQLiteOpenHelper {
    public static final String LOG_TAG = "WinzigSQL";
    private final Context context;
    private final String dbName;

    public WinzigDbScriptHelper(Context context, String dbName, int dbVersion) {
        super(context, dbName, null, dbVersion);
        this.dbName = dbName;
        this.context = context.getApplicationContext();
    }

    public void onCreate(SQLiteDatabase db) {
        try {
            String sqlStatements = ResourceUtils.readRawResourceAsString(this.context, this.context.getResources().getIdentifier("create_db", "raw", this.context.getApplicationContext().getPackageName()));
            SqlUtils.executeStatements(db, sqlStatements);
            Log.d((String)LOG_TAG, (String)"db created");
        }
        catch (IOException ioe) {
            throw new SQLiteException("Could not initialize database." + ioe.getMessage());
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        for (int n = oldVersion; n < newVersion; ++n) {
            String updateResourceName = "upgrade_db_" + n;
            try {
                int resourceId = this.context.getResources().getIdentifier(updateResourceName, "raw", this.context.getApplicationContext().getPackageName());
                if (resourceId == 0) {
                    Log.d((String)LOG_TAG, (String)("skipping update for version " + n + ", resource not found: " + updateResourceName));
                    continue;
                }
                String sqlStatements = ResourceUtils.readRawResourceAsString(this.context, resourceId);
                SqlUtils.executeStatements(db, sqlStatements);
                Log.d((String)LOG_TAG, (String)("db updated to version " + n));
                continue;
            }
            catch (IOException ioe) {
                throw new SQLiteException("Could not update database to version " + n + ", problem with resource " + updateResourceName + "? " + ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        Cursor c = db.rawQuery("PRAGMA foreign_keys;", new String[0]);
        boolean foreignKeysDisabled = true;
        try {
            if (c.isAfterLast()) {
                throw new SQLiteException("Db has no foreign key support.");
            }
            c.moveToNext();
            foreignKeysDisabled = c.getInt(0) == 0;
        }
        finally {
            c.close();
        }
        if (foreignKeysDisabled) {
            if (!db.isReadOnly()) {
                db.execSQL("PRAGMA foreign_keys=ON;");
            } else {
                throw new SQLiteException("Cannot activate foreign key support, db is read-only.");
            }
        }
    }

    public boolean dropDb() {
        return this.context.deleteDatabase(this.dbName);
    }
}

