/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.ClassSignatureLookup;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.WrapperRuntimeException;
import de.thetaphi.forbiddenapis.asm.AnnotationVisitor;
import de.thetaphi.forbiddenapis.asm.ClassReader;
import de.thetaphi.forbiddenapis.asm.ClassVisitor;
import de.thetaphi.forbiddenapis.asm.FieldVisitor;
import de.thetaphi.forbiddenapis.asm.Handle;
import de.thetaphi.forbiddenapis.asm.Label;
import de.thetaphi.forbiddenapis.asm.MethodVisitor;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.TypePath;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class Checker {
    public final boolean isSupportedJDK;
    private final long start;
    final Set<File> bootClassPathJars;
    final Set<String> bootClassPathDirs;
    final ClassLoader loader;
    final boolean internalRuntimeForbidden;
    final boolean failOnMissingClasses;
    final boolean defaultFailOnUnresolvableSignatures;
    final Map<String, ClassSignatureLookup> classesToCheck = new HashMap<String, ClassSignatureLookup>();
    final Map<String, ClassSignatureLookup> classpathClassCache = new HashMap<String, ClassSignatureLookup>();
    final Map<String, String> forbiddenFields = new HashMap<String, String>();
    final Map<String, String> forbiddenMethods = new HashMap<String, String>();
    final Map<String, String> forbiddenClasses = new HashMap<String, String>();
    private static final String BUNDLED_PREFIX = "@includeBundled ";
    private static final String DEFAULT_MESSAGE_PREFIX = "@defaultMessage ";
    private static final String IGNORE_UNRESOLVABLE_LINE = "@ignoreUnresolvable";

    protected abstract void logError(String var1);

    protected abstract void logWarn(String var1);

    protected abstract void logInfo(String var1);

    public Checker(ClassLoader loader, boolean internalRuntimeForbidden, boolean failOnMissingClasses, boolean defaultFailOnUnresolvableSignatures) {
        this.loader = loader;
        this.internalRuntimeForbidden = internalRuntimeForbidden;
        this.failOnMissingClasses = failOnMissingClasses;
        this.defaultFailOnUnresolvableSignatures = defaultFailOnUnresolvableSignatures;
        this.start = System.currentTimeMillis();
        boolean isSupportedJDK = false;
        LinkedHashSet<File> bootClassPathJars = new LinkedHashSet<File>();
        LinkedHashSet<String> bootClassPathDirs = new LinkedHashSet<String>();
        try {
            RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
            if (rb.isBootClassPathSupported()) {
                String cp = rb.getBootClassPath();
                StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    File f = new File(st.nextToken());
                    if (f.isFile()) {
                        bootClassPathJars.add(f.getCanonicalFile());
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    String fp = f.getCanonicalPath();
                    if (!fp.endsWith(File.separator)) {
                        fp = fp + File.separator;
                    }
                    bootClassPathDirs.add(fp);
                }
            }
            isSupportedJDK = !bootClassPathJars.isEmpty() || !bootClassPathDirs.isEmpty();
        }
        catch (IOException ioe) {
            isSupportedJDK = false;
            bootClassPathJars.clear();
            bootClassPathDirs.clear();
        }
        this.bootClassPathJars = Collections.unmodifiableSet(bootClassPathJars);
        this.bootClassPathDirs = Collections.unmodifiableSet(bootClassPathDirs);
        if (isSupportedJDK) {
            try {
                isSupportedJDK = this.getClassFromClassLoader((String)Object.class.getName()).isRuntimeClass;
            }
            catch (IllegalArgumentException iae) {
                isSupportedJDK = false;
            }
            catch (ClassNotFoundException cnfe) {
                isSupportedJDK = false;
            }
        }
        this.isSupportedJDK = isSupportedJDK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassSignatureLookup getClassFromClassLoader(String clazz) throws ClassNotFoundException {
        ClassSignatureLookup c;
        if (this.classpathClassCache.containsKey(clazz)) {
            c = this.classpathClassCache.get(clazz);
            if (c == null) {
                throw new ClassNotFoundException("Class '" + clazz + "' not found on classpath");
            }
        } else {
            try {
                URL jarUrl;
                URL url = this.loader.getResource(clazz.replace('.', '/') + ".class");
                if (url == null) {
                    this.classpathClassCache.put(clazz, null);
                    throw new ClassNotFoundException("Class '" + clazz + "' not found on classpath");
                }
                boolean isRuntimeClass = false;
                URLConnection conn = url.openConnection();
                if ("file".equalsIgnoreCase(url.getProtocol())) {
                    try {
                        String path = new File(url.toURI()).getCanonicalPath();
                        for (String bcpDir : this.bootClassPathDirs) {
                            if (!path.startsWith(bcpDir)) continue;
                            isRuntimeClass = true;
                        }
                    }
                    catch (URISyntaxException use) {}
                } else if (conn instanceof JarURLConnection && "file".equalsIgnoreCase((jarUrl = ((JarURLConnection)conn).getJarFileURL()).getProtocol())) {
                    try {
                        File jarFile = new File(jarUrl.toURI()).getCanonicalFile();
                        isRuntimeClass = this.bootClassPathJars.contains(jarFile);
                    }
                    catch (URISyntaxException use) {
                        // empty catch block
                    }
                }
                InputStream in = conn.getInputStream();
                try {
                    c = new ClassSignatureLookup(new ClassReader(in), isRuntimeClass, false);
                    this.classpathClassCache.put(clazz, c);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                this.classpathClassCache.put(clazz, null);
                throw new ClassNotFoundException("I/O error while loading of class '" + clazz + "'", ioe);
            }
        }
        return c;
    }

    private void reportParseFailed(boolean failOnUnresolvableSignatures, String message, String signature) throws ParseException {
        if (failOnUnresolvableSignatures) {
            throw new ParseException(String.format(Locale.ENGLISH, "%s while parsing signature: %s", message, signature));
        }
        this.logWarn(String.format(Locale.ENGLISH, "%s while parsing signature: %s [signature ignored]", message, signature));
    }

    private void addSignature(String line, String defaultMessage, boolean failOnUnresolvableSignatures) throws ParseException {
        ClassSignatureLookup c;
        String field;
        Method method;
        String clazz;
        String message;
        String signature;
        int p = line.indexOf(64);
        if (p >= 0) {
            signature = line.substring(0, p).trim();
            message = line.substring(p + 1).trim();
        } else {
            signature = line;
            message = defaultMessage;
        }
        p = signature.indexOf(35);
        if (p >= 0) {
            clazz = signature.substring(0, p);
            String s = signature.substring(p + 1);
            if ((p = s.indexOf(40)) >= 0) {
                if (p == 0) {
                    throw new ParseException("Invalid method signature (method name missing): " + signature);
                }
                try {
                    method = Method.getMethod("void " + s, true);
                }
                catch (IllegalArgumentException iae) {
                    throw new ParseException("Invalid method signature: " + signature);
                }
                field = null;
            } else {
                field = s;
                method = null;
            }
        } else {
            clazz = signature;
            method = null;
            field = null;
        }
        String printout = message != null && message.length() > 0 ? signature + " [" + message + "]" : signature;
        try {
            c = this.getClassFromClassLoader(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            this.reportParseFailed(failOnUnresolvableSignatures, cnfe.getMessage(), signature);
            return;
        }
        if (method != null) {
            assert (field == null);
            boolean found = false;
            for (Method m : c.methods) {
                if (!m.getName().equals(method.getName()) || !Arrays.equals(m.getArgumentTypes(), method.getArgumentTypes())) continue;
                found = true;
                this.forbiddenMethods.put(c.className + '\u0000' + m, printout);
            }
            if (!found) {
                this.reportParseFailed(failOnUnresolvableSignatures, "Method not found", signature);
                return;
            }
        } else if (field != null) {
            assert (method == null);
            if (!c.fields.contains(field)) {
                this.reportParseFailed(failOnUnresolvableSignatures, "Field not found", signature);
                return;
            }
            this.forbiddenFields.put(c.className + '\u0000' + field, printout);
        } else {
            assert (field == null && method == null);
            this.forbiddenClasses.put(c.className, printout);
        }
    }

    public final void parseBundledSignatures(String name, String jdkTargetVersion) throws IOException, ParseException {
        if (!name.matches("[A-Za-z0-9\\-\\.]+")) {
            throw new ParseException("Invalid bundled signature reference: " + name);
        }
        InputStream in = this.getClass().getResourceAsStream("signatures/" + name + ".txt");
        if (in == null && jdkTargetVersion != null && name.startsWith("jdk-") && !name.matches(".*?\\-\\d\\.\\d")) {
            name = name + "-" + jdkTargetVersion;
            in = this.getClass().getResourceAsStream("signatures/" + name + ".txt");
        }
        if (in == null) {
            throw new FileNotFoundException("Bundled signatures resource not found: " + name);
        }
        this.parseSignaturesFile(in, true);
    }

    public final void parseSignaturesFile(InputStream in) throws IOException, ParseException {
        this.parseSignaturesFile(in, false);
    }

    public final void parseSignaturesString(String signatures) throws IOException, ParseException {
        this.parseSignaturesFile(new StringReader(signatures), false);
    }

    private void parseSignaturesFile(InputStream in, boolean allowBundled) throws IOException, ParseException {
        this.parseSignaturesFile(new InputStreamReader(in, "UTF-8"), allowBundled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSignaturesFile(Reader reader, boolean allowBundled) throws IOException, ParseException {
        BufferedReader r = new BufferedReader(reader);
        try {
            String line;
            String defaultMessage = null;
            boolean failOnUnresolvableSignatures = this.defaultFailOnUnresolvableSignatures;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("@")) {
                    if (allowBundled && line.startsWith(BUNDLED_PREFIX)) {
                        String name = line.substring(BUNDLED_PREFIX.length()).trim();
                        this.parseBundledSignatures(name, null);
                        continue;
                    }
                    if (line.startsWith(DEFAULT_MESSAGE_PREFIX)) {
                        defaultMessage = line.substring(DEFAULT_MESSAGE_PREFIX.length()).trim();
                        if (defaultMessage.length() != 0) continue;
                        defaultMessage = null;
                        continue;
                    }
                    if (line.equals(IGNORE_UNRESOLVABLE_LINE)) {
                        failOnUnresolvableSignatures = false;
                        continue;
                    }
                    throw new ParseException("Invalid line in signature file: " + line);
                }
                this.addSignature(line, defaultMessage, failOnUnresolvableSignatures);
            }
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addClassToCheck(InputStream in) throws IOException {
        ClassReader reader;
        try {
            reader = new ClassReader(in);
        }
        finally {
            in.close();
        }
        this.classesToCheck.put(reader.getClassName(), new ClassSignatureLookup(reader, false, true));
    }

    public final boolean hasNoSignatures() {
        return this.forbiddenMethods.isEmpty() && this.forbiddenClasses.isEmpty() && this.forbiddenFields.isEmpty() && !this.internalRuntimeForbidden;
    }

    private int checkClass(final ClassReader reader) {
        final int[] violations = new int[1];
        reader.accept(new ClassVisitor(327680){
            final String className;
            String source;
            {
                super(x0);
                this.className = Type.getObjectType(reader.getClassName()).getClassName();
                this.source = null;
            }

            ClassSignatureLookup lookupRelatedClass(String internalName) {
                Type type = Type.getObjectType(internalName);
                if (type.getSort() != 10) {
                    return null;
                }
                ClassSignatureLookup c = Checker.this.classesToCheck.get(internalName);
                if (c == null) {
                    try {
                        c = Checker.this.getClassFromClassLoader(type.getClassName());
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (Checker.this.failOnMissingClasses) {
                            throw new WrapperRuntimeException(cnfe);
                        }
                        Checker.this.logWarn(String.format(Locale.ENGLISH, "The referenced class '%s' cannot be loaded. Please fix the classpath!", type.getClassName()));
                    }
                }
                return c;
            }

            private boolean isInternalClass(String className) {
                return className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("com.oracle.") || className.startsWith("jdk.") || className.startsWith("sunw.");
            }

            boolean checkClassUse(String internalName) {
                ClassSignatureLookup c;
                String referencedClassName;
                String printout = Checker.this.forbiddenClasses.get(internalName);
                if (printout != null) {
                    Checker.this.logError("Forbidden class/interface/annotation use: " + printout);
                    return true;
                }
                if (Checker.this.internalRuntimeForbidden && this.isInternalClass(referencedClassName = Type.getObjectType(internalName).getClassName()) && ((c = this.lookupRelatedClass(internalName)) == null || c.isRuntimeClass)) {
                    Checker.this.logError(String.format(Locale.ENGLISH, "Forbidden class/interface/annotation use: %s [non-public internal runtime class]", referencedClassName));
                    return true;
                }
                return false;
            }

            private boolean checkClassDefinition(String superName, String[] interfaces) {
                if (superName != null) {
                    if (this.checkClassUse(superName)) {
                        return true;
                    }
                    ClassSignatureLookup c = this.lookupRelatedClass(superName);
                    if (c != null && this.checkClassDefinition(c.superName, c.interfaces)) {
                        return true;
                    }
                }
                if (interfaces != null) {
                    for (String intf : interfaces) {
                        if (this.checkClassUse(intf)) {
                            return true;
                        }
                        ClassSignatureLookup c = this.lookupRelatedClass(intf);
                        if (c == null || !this.checkClassDefinition(c.superName, c.interfaces)) continue;
                        return true;
                    }
                }
                return false;
            }

            boolean checkType(Type type) {
                block5: while (type != null) {
                    switch (type.getSort()) {
                        case 10: {
                            if (this.checkClassUse(type.getInternalName())) {
                                return true;
                            }
                            ClassSignatureLookup c = this.lookupRelatedClass(type.getInternalName());
                            return c != null && this.checkClassDefinition(c.superName, c.interfaces);
                        }
                        case 9: {
                            type = type.getElementType();
                            continue block5;
                        }
                        case 11: {
                            boolean violation = this.checkType(type.getReturnType());
                            for (Type t : type.getArgumentTypes()) {
                                violation |= this.checkType(t);
                            }
                            return violation;
                        }
                    }
                    return false;
                }
                return false;
            }

            boolean checkDescriptor(String desc) {
                return this.checkType(Type.getType(desc));
            }

            private void reportClassViolation(boolean violation, String where) {
                if (violation) {
                    violations[0] = violations[0] + 1;
                    StringBuilder sb = new StringBuilder("  in ").append(this.className);
                    if (this.source != null) {
                        new Formatter(sb, Locale.ENGLISH).format(" (%s, %s)", this.source, where).flush();
                    } else {
                        new Formatter(sb, Locale.ENGLISH).format(" (%s)", where).flush();
                    }
                    Checker.this.logError(sb.toString());
                }
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.reportClassViolation(this.checkClassDefinition(superName, interfaces), "class declaration");
            }

            public void visitSource(String source, String debug) {
                this.source = source;
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (visible) {
                    this.reportClassViolation(this.checkDescriptor(desc), "annotation on class declaration");
                }
                return null;
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                if (visible) {
                    this.reportClassViolation(this.checkDescriptor(desc), "type annotation on class declaration");
                }
                return null;
            }

            public FieldVisitor visitField(final int access, final String name, final String desc, String signature, Object value) {
                return new FieldVisitor(327680){
                    {
                        super(x0);
                        if ((access & 0x1000) == 0) {
                            this.reportFieldViolation(this.checkDescriptor(desc), "field declaration");
                        }
                    }

                    public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                        if (visible) {
                            this.reportFieldViolation(this.checkDescriptor(desc2), "annotation on field declaration");
                        }
                        return null;
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                        if (visible) {
                            this.reportFieldViolation(this.checkDescriptor(desc2), "type annotation on field declaration");
                        }
                        return null;
                    }

                    private void reportFieldViolation(boolean violation, String where) {
                        if (violation) {
                            violations[0] = violations[0] + 1;
                            StringBuilder sb = new StringBuilder("  in ").append(className);
                            if (source != null) {
                                new Formatter(sb, Locale.ENGLISH).format(" (%s, %s of '%s')", source, where, name).flush();
                            } else {
                                new Formatter(sb, Locale.ENGLISH).format(" (%s of '%s')", where, name).flush();
                            }
                            Checker.this.logError(sb.toString());
                        }
                    }
                };
            }

            public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
                return new MethodVisitor(327680){
                    private int lineNo;
                    {
                        super(x0);
                        this.lineNo = -1;
                        if ((access & 0x1000) == 0) {
                            this.reportMethodViolation(this.checkDescriptor(desc), "method declaration");
                        }
                    }

                    private boolean checkMethodAccess(String owner, Method method) {
                        if (this.checkClassUse(owner)) {
                            return true;
                        }
                        String printout = Checker.this.forbiddenMethods.get(owner + '\u0000' + method);
                        if (printout != null) {
                            Checker.this.logError("Forbidden method invocation: " + printout);
                            return true;
                        }
                        ClassSignatureLookup c = this.lookupRelatedClass(owner);
                        if (c != null && !c.methods.contains(method)) {
                            if (c.superName != null && this.checkMethodAccess(c.superName, method)) {
                                return true;
                            }
                            if (c.interfaces != null) {
                                for (String intf : c.interfaces) {
                                    if (intf == null || !this.checkMethodAccess(intf, method)) continue;
                                    return true;
                                }
                            }
                        }
                        return false;
                    }

                    private boolean checkFieldAccess(String owner, String field) {
                        if (this.checkClassUse(owner)) {
                            return true;
                        }
                        String printout = Checker.this.forbiddenFields.get(owner + '\u0000' + field);
                        if (printout != null) {
                            Checker.this.logError("Forbidden field access: " + printout);
                            return true;
                        }
                        ClassSignatureLookup c = this.lookupRelatedClass(owner);
                        if (c != null && !c.fields.contains(field)) {
                            if (c.interfaces != null) {
                                for (String intf : c.interfaces) {
                                    if (intf == null || !this.checkFieldAccess(intf, field)) continue;
                                    return true;
                                }
                            }
                            if (c.superName != null && this.checkFieldAccess(c.superName, field)) {
                                return true;
                            }
                        }
                        return false;
                    }

                    private boolean checkHandle(Handle handle) {
                        switch (handle.getTag()) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                return this.checkFieldAccess(handle.getOwner(), handle.getName());
                            }
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                return this.checkMethodAccess(handle.getOwner(), new Method(handle.getName(), handle.getDesc()));
                            }
                        }
                        return false;
                    }

                    private boolean checkConstant(Object cst) {
                        return cst instanceof Type ? this.checkType((Type)cst) : cst instanceof Handle && this.checkHandle((Handle)cst);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name2, String desc2, boolean itf) {
                        this.reportMethodViolation(this.checkMethodAccess(owner, new Method(name2, desc2)), "method body");
                    }

                    public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                        this.reportMethodViolation(this.checkFieldAccess(owner, name2), "method body");
                    }

                    public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                        if (visible) {
                            this.reportMethodViolation(this.checkDescriptor(desc2), "annotation on method declaration");
                        }
                        return null;
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc2, boolean visible) {
                        if (visible) {
                            this.reportMethodViolation(this.checkDescriptor(desc2), "parameter annotation on method declaration");
                        }
                        return null;
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                        if (visible) {
                            this.reportMethodViolation(this.checkDescriptor(desc2), "type annotation on method declaration");
                        }
                        return null;
                    }

                    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                        if (visible) {
                            this.reportMethodViolation(this.checkDescriptor(desc2), "annotation in method body");
                        }
                        return null;
                    }

                    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc2, boolean visible) {
                        if (visible) {
                            this.reportMethodViolation(this.checkDescriptor(desc2), "annotation in method body");
                        }
                        return null;
                    }

                    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                        if (visible) {
                            this.reportMethodViolation(this.checkDescriptor(desc2), "annotation in method body");
                        }
                        return null;
                    }

                    public void visitTypeInsn(int opcode, String type) {
                        if (opcode == 189) {
                            this.reportMethodViolation(this.checkType(Type.getObjectType(type)), "method body");
                        }
                    }

                    public void visitMultiANewArrayInsn(String desc2, int dims) {
                        this.reportMethodViolation(this.checkDescriptor(desc2), "method body");
                    }

                    public void visitLdcInsn(Object cst) {
                        this.reportMethodViolation(this.checkConstant(cst), "method body");
                    }

                    public void visitInvokeDynamicInsn(String name2, String desc2, Handle bsm, Object ... bsmArgs) {
                        this.reportMethodViolation(this.checkHandle(bsm), "method body");
                        for (Object cst : bsmArgs) {
                            this.reportMethodViolation(this.checkConstant(cst), "method body");
                        }
                    }

                    private String getHumanReadableMethodSignature() {
                        Type[] args = Type.getType(desc).getArgumentTypes();
                        StringBuilder sb = new StringBuilder(name).append('(');
                        boolean comma = false;
                        for (Type t : args) {
                            if (comma) {
                                sb.append(',');
                            }
                            sb.append(t.getClassName());
                            comma = true;
                        }
                        sb.append(')');
                        return sb.toString();
                    }

                    private void reportMethodViolation(boolean violation, String where) {
                        if (violation) {
                            violations[0] = violations[0] + 1;
                            StringBuilder sb = new StringBuilder("  in ").append(className);
                            if (source != null) {
                                if (this.lineNo >= 0) {
                                    new Formatter(sb, Locale.ENGLISH).format(" (%s:%d)", source, this.lineNo).flush();
                                } else {
                                    new Formatter(sb, Locale.ENGLISH).format(" (%s, %s of '%s')", source, where, this.getHumanReadableMethodSignature()).flush();
                                }
                            } else {
                                new Formatter(sb, Locale.ENGLISH).format(" (%s of '%s')", where, this.getHumanReadableMethodSignature()).flush();
                            }
                            Checker.this.logError(sb.toString());
                        }
                    }

                    public void visitLineNumber(int lineNo, Label start) {
                        this.lineNo = lineNo;
                    }
                };
            }
        }, 4);
        return violations[0];
    }

    public final void run() throws ForbiddenApiException {
        int errors = 0;
        try {
            for (ClassSignatureLookup c : this.classesToCheck.values()) {
                errors += this.checkClass(c.getReader());
            }
        }
        catch (WrapperRuntimeException wre) {
            Throwable cause = wre.getCause();
            throw new ForbiddenApiException("Check for forbidden API calls failed: " + cause.toString());
        }
        String message = String.format(Locale.ENGLISH, "Scanned %d (and %d related) class file(s) for forbidden API invocations (in %.2fs), %d error(s).", this.classesToCheck.size(), this.classesToCheck.isEmpty() ? 0 : this.classpathClassCache.size(), (double)(System.currentTimeMillis() - this.start) / 1000.0, errors);
        if (errors > 0) {
            this.logError(message);
            throw new ForbiddenApiException("Check for forbidden API calls failed, see log.");
        }
        this.logInfo(message);
    }
}

