/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.commons.cli.CommandLine;
import de.thetaphi.forbiddenapis.commons.cli.HelpFormatter;
import de.thetaphi.forbiddenapis.commons.cli.Option;
import de.thetaphi.forbiddenapis.commons.cli.OptionBuilder;
import de.thetaphi.forbiddenapis.commons.cli.OptionGroup;
import de.thetaphi.forbiddenapis.commons.cli.Options;
import de.thetaphi.forbiddenapis.commons.cli.ParseException;
import de.thetaphi.forbiddenapis.commons.cli.PosixParser;
import de.thetaphi.forbiddenapis.plexus.util.DirectoryScanner;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Locale;

public final class CliMain {
    private final Option classpathOpt;
    private final Option dirOpt;
    private final Option includesOpt;
    private final Option excludesOpt;
    private final Option signaturesfileOpt;
    private final Option bundledsignaturesOpt;
    private final Option internalruntimeforbiddenOpt;
    private final Option allowmissingclassesOpt;
    private final Option allowunresolvablesignaturesOpt;
    private final Option versionOpt;
    private final Option helpOpt;
    private final CommandLine cmd;
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_VIOLATION = 1;
    public static final int EXIT_ERR_CMDLINE = 2;
    public static final int EXIT_UNSUPPORTED_JDK = 3;
    public static final int EXIT_ERR_OTHER = 4;

    public CliMain(String ... args) throws ExitException {
        OptionGroup required = new OptionGroup();
        required.setRequired(true);
        OptionBuilder.withDescription("directory with class files to check for forbidden api usage; this directory is also added to classpath");
        OptionBuilder.withLongOpt("dir");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("directory");
        this.dirOpt = OptionBuilder.create('d');
        required.addOption(this.dirOpt);
        OptionBuilder.withDescription("print product version and exit");
        OptionBuilder.withLongOpt("version");
        this.versionOpt = OptionBuilder.create('V');
        required.addOption(this.versionOpt);
        OptionBuilder.withDescription("print this help");
        OptionBuilder.withLongOpt("help");
        this.helpOpt = OptionBuilder.create('h');
        required.addOption(this.helpOpt);
        Options options = new Options();
        options.addOptionGroup(required);
        OptionBuilder.withDescription("class search path of directories and zip/jar files");
        OptionBuilder.withLongOpt("classpath");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator(File.pathSeparatorChar);
        OptionBuilder.withArgName("path");
        this.classpathOpt = OptionBuilder.create('c');
        options.addOption(this.classpathOpt);
        OptionBuilder.withDescription("ANT-style pattern to select class files (separated by commas or option can be given multiple times, defaults to '**/*.class')");
        OptionBuilder.withLongOpt("includes");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator(',');
        OptionBuilder.withArgName("pattern");
        this.includesOpt = OptionBuilder.create('i');
        options.addOption(this.includesOpt);
        OptionBuilder.withDescription("ANT-style pattern to exclude some files from checks (separated by commas or option can be given multiple times)");
        OptionBuilder.withLongOpt("excludes");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator(',');
        OptionBuilder.withArgName("pattern");
        this.excludesOpt = OptionBuilder.create('e');
        options.addOption(this.excludesOpt);
        OptionBuilder.withDescription("path to a file containing signatures (option can be given multiple times)");
        OptionBuilder.withLongOpt("signaturesfile");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        this.signaturesfileOpt = OptionBuilder.create('f');
        options.addOption(this.signaturesfileOpt);
        OptionBuilder.withDescription("name of a bundled signatures definition (separated by commas or option can be given multiple times)");
        OptionBuilder.withLongOpt("bundledsignatures");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator(',');
        OptionBuilder.withArgName("name");
        this.bundledsignaturesOpt = OptionBuilder.create('b');
        options.addOption(this.bundledsignaturesOpt);
        OptionBuilder.withDescription("forbids calls to classes from the internal java runtime (like sun.misc.Unsafe)");
        OptionBuilder.withLongOpt("internalruntimeforbidden");
        this.internalruntimeforbiddenOpt = OptionBuilder.create();
        options.addOption(this.internalruntimeforbiddenOpt);
        OptionBuilder.withDescription("don't fail if a referenced class is missing on classpath");
        OptionBuilder.withLongOpt("allowmissingclasses");
        this.allowmissingclassesOpt = OptionBuilder.create();
        options.addOption(this.allowmissingclassesOpt);
        OptionBuilder.withDescription("don't fail if a signature is not resolving");
        OptionBuilder.withLongOpt("allowunresolvablesignatures");
        this.allowunresolvablesignaturesOpt = OptionBuilder.create();
        options.addOption(this.allowunresolvablesignaturesOpt);
        try {
            this.cmd = new PosixParser().parse(options, args);
            if (this.cmd.hasOption(this.helpOpt.getLongOpt())) {
                this.printHelp(options);
                throw new ExitException(0);
            }
            if (this.cmd.hasOption(this.versionOpt.getLongOpt())) {
                this.printVersion();
                throw new ExitException(0);
            }
        }
        catch (ParseException pe) {
            this.printHelp(options);
            throw new ExitException(2);
        }
    }

    void logError(String msg) {
        System.err.println("ERROR: " + msg);
    }

    void logWarn(String msg) {
        System.err.println("WARNING: " + msg);
    }

    void logInfo(String msg) {
        System.out.println(msg);
    }

    private void printVersion() {
        Package pkg = this.getClass().getPackage();
        this.logInfo(String.format(Locale.ENGLISH, "%s %s", pkg.getImplementationTitle(), pkg.getImplementationVersion()));
    }

    private void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String cmdline = "java " + this.getClass().getName();
        try {
            URL jarUrl;
            URLConnection conn = this.getClass().getResource(this.getClass().getSimpleName() + ".class").openConnection();
            if (conn instanceof JarURLConnection && "file".equalsIgnoreCase((jarUrl = ((JarURLConnection)conn).getJarFileURL()).getProtocol())) {
                String cwd = new File(".").getCanonicalPath();
                String path = new File(jarUrl.toURI()).getCanonicalPath();
                cmdline = "java -jar " + (path.startsWith(cwd) ? path.substring(cwd.length() + File.separator.length()) : path);
            }
        }
        catch (IOException ioe) {
        }
        catch (URISyntaxException use) {
            // empty catch block
        }
        formatter.printHelp(cmdline + " [options]", "Scans a set of class files for forbidden API usage.", options, String.format(Locale.ENGLISH, "Exit codes: %d = SUCCESS, %d = forbidden API detected, %d = invalid command line, %d = unsupported JDK version, %d = other error (I/O,...)", 0, 1, 2, 3, 4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws ExitException {
        URL[] urls;
        File classesDirectory = new File(this.cmd.getOptionValue(this.dirOpt.getLongOpt())).getAbsoluteFile();
        String[] classpath = this.cmd.getOptionValues(this.classpathOpt.getLongOpt());
        try {
            if (classpath == null) {
                urls = new URL[]{classesDirectory.toURI().toURL()};
            } else {
                urls = new URL[classpath.length + 1];
                int i = 0;
                for (String cpElement : classpath) {
                    urls[i++] = new File(cpElement).toURI().toURL();
                }
                urls[i++] = classesDirectory.toURI().toURL();
                assert (i == urls.length);
            }
        }
        catch (MalformedURLException mfue) {
            throw new ExitException(4, "The given classpath is invalid: " + mfue);
        }
        URLClassLoader loader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
        try {
            Checker checker = new Checker(loader, this.cmd.hasOption(this.internalruntimeforbiddenOpt.getLongOpt()), !this.cmd.hasOption(this.allowmissingclassesOpt.getLongOpt()), !this.cmd.hasOption(this.allowunresolvablesignaturesOpt.getLongOpt())){

                protected void logError(String msg) {
                    CliMain.this.logError(msg);
                }

                protected void logWarn(String msg) {
                    CliMain.this.logWarn(msg);
                }

                protected void logInfo(String msg) {
                    CliMain.this.logInfo(msg);
                }
            };
            if (!checker.isSupportedJDK) {
                throw new ExitException(3, String.format(Locale.ENGLISH, "Your Java runtime (%s %s) is not supported by forbiddenapis. Please run the checks with a supported JDK!", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version")));
            }
            this.logInfo("Scanning for classes to check...");
            if (!classesDirectory.exists()) {
                throw new ExitException(4, "Directory with class files does not exist: " + classesDirectory);
            }
            Object[] includes = this.cmd.getOptionValues(this.includesOpt.getLongOpt());
            if (includes == null || includes.length == 0) {
                includes = new String[]{"**/*.class"};
            }
            Object[] excludes = this.cmd.getOptionValues(this.excludesOpt.getLongOpt());
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(classesDirectory);
            ds.setCaseSensitive(true);
            ds.setIncludes((String[])includes);
            ds.setExcludes((String[])excludes);
            ds.addDefaultExcludes();
            ds.scan();
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                throw new ExitException(4, String.format(Locale.ENGLISH, "No classes found in directory %s (includes=%s, excludes=%s).", classesDirectory, Arrays.toString(includes), Arrays.toString(excludes)));
            }
            try {
                String[] signaturesFiles;
                String[] bundledSignatures = this.cmd.getOptionValues(this.bundledsignaturesOpt.getLongOpt());
                if (bundledSignatures != null) {
                    for (String bs : bundledSignatures) {
                        this.logInfo("Reading bundled API signatures: " + bs);
                        checker.parseBundledSignatures(bs, null);
                    }
                }
                if ((signaturesFiles = this.cmd.getOptionValues(this.signaturesfileOpt.getLongOpt())) != null) {
                    for (String sf : signaturesFiles) {
                        File f = new File(sf).getAbsoluteFile();
                        this.logInfo("Reading API signatures: " + f);
                        checker.parseSignaturesFile(new FileInputStream(f));
                    }
                }
            }
            catch (IOException ioe) {
                throw new ExitException(4, "IO problem while reading files with API signatures: " + ioe);
            }
            catch (de.thetaphi.forbiddenapis.ParseException pe) {
                throw new ExitException(4, "Parsing signatures failed: " + pe.getMessage());
            }
            if (checker.hasNoSignatures()) {
                throw new ExitException(2, String.format(Locale.ENGLISH, "No API signatures found; use parameters '--%s', '--%s', and/or '--%s' to define those!", this.bundledsignaturesOpt.getLongOpt(), this.signaturesfileOpt.getLongOpt(), this.internalruntimeforbiddenOpt.getLongOpt()));
            }
            this.logInfo("Loading classes to check...");
            try {
                for (String f : files) {
                    checker.addClassToCheck(new FileInputStream(new File(classesDirectory, f)));
                }
            }
            catch (IOException ioe) {
                throw new ExitException(4, "Failed to load one of the given class files: " + ioe);
            }
            this.logInfo("Scanning for API signatures and dependencies...");
            try {
                checker.run();
            }
            catch (ForbiddenApiException fae) {
                throw new ExitException(1, fae.getMessage());
            }
        }
        finally {
            if (loader instanceof Closeable) {
                try {
                    ((Closeable)loader).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static void main(String ... args) {
        block3: {
            try {
                new CliMain(args).run();
            }
            catch (ExitException e) {
                if (e.getMessage() != null) {
                    System.err.println("ERROR: " + e.getMessage());
                }
                if (e.exitCode == 0) break block3;
                System.exit(e.exitCode);
            }
        }
    }

    public static final class ExitException
    extends Exception {
        public final int exitCode;

        public ExitException(int exitCode) {
            this(exitCode, null);
        }

        public ExitException(int exitCode, String message) {
            super(message);
            this.exitCode = exitCode;
        }
    }
}

