/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.asm.ClassReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import java.util.regex.Pattern;

public final class AsmUtils {
    private static final String REGEX_META_CHARS = ".^$+{}[]|()\\";
    private static final Pattern PORTABLE_RUNTIME_PACKAGE_PATTERN = AsmUtils.makePkgPrefixPattern("java", "javax", "org.ietf.jgss", "org.omg", "org.w3c.dom", "org.xml.sax");
    private static final Pattern RUNTIME_MODULES_PATTERN = AsmUtils.makePkgPrefixPattern("java", "jdk");

    private AsmUtils() {
    }

    private static Pattern makePkgPrefixPattern(String ... prefixes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String p : prefixes) {
            sb.append(first ? (char)'(' : '|').append(Pattern.quote(p));
            first = false;
        }
        sb.append(")").append(Pattern.quote(".")).append(".*");
        return Pattern.compile(sb.toString());
    }

    private static boolean isRegexMeta(char c) {
        return REGEX_META_CHARS.indexOf(c) != -1;
    }

    public static boolean isPortableRuntimeClass(String className) {
        return PORTABLE_RUNTIME_PACKAGE_PATTERN.matcher(className).matches();
    }

    public static boolean isRuntimeModule(String module) {
        return module != null && RUNTIME_MODULES_PATTERN.matcher(module).matches();
    }

    public static String binaryToInternal(String clazz) {
        if (clazz.indexOf(47) >= 0 || clazz.indexOf(91) >= 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "'%s' is not a valid binary class name.", clazz));
        }
        return clazz.replace('.', '/');
    }

    public static String getClassResourceName(String clazz) {
        return AsmUtils.binaryToInternal(clazz).concat(".class");
    }

    public static boolean isGlob(String s) {
        return s.indexOf(42) >= 0 || s.indexOf(63) >= 0;
    }

    public static Pattern glob2Pattern(String ... globs) {
        StringBuilder regex = new StringBuilder();
        boolean needOr = false;
        for (String glob : globs) {
            if (needOr) {
                regex.append('|');
            }
            int i = 0;
            int len = glob.length();
            block5: while (i < len) {
                char c = glob.charAt(i++);
                switch (c) {
                    case '*': {
                        if (i < len && glob.charAt(i) == '*') {
                            regex.append(".*");
                            ++i;
                            continue block5;
                        }
                        regex.append("[^.]*");
                        continue block5;
                    }
                    case '?': {
                        regex.append("[^.]");
                        continue block5;
                    }
                }
                if (AsmUtils.isRegexMeta(c)) {
                    regex.append('\\');
                }
                regex.append(c);
            }
            needOr = true;
        }
        return Pattern.compile(regex.toString(), 0);
    }

    public static String getModuleName(URL jrtUrl) {
        if (!"jrt".equalsIgnoreCase(jrtUrl.getProtocol())) {
            return null;
        }
        try {
            String mod = jrtUrl.toURI().getPath();
            if (mod != null && mod.length() >= 1) {
                int p = (mod = mod.substring(1)).indexOf(47);
                if (p >= 0) {
                    mod = mod.substring(0, p);
                }
                return mod.isEmpty() ? null : mod;
            }
            return null;
        }
        catch (URISyntaxException use) {
            return null;
        }
    }

    private static void patchClassMajorVersion(byte[] header, int versionFrom, int versionTo) {
        ByteBuffer buf = ByteBuffer.wrap(header).order(ByteOrder.BIG_ENDIAN);
        if (buf.getShort(6) == versionFrom) {
            buf.putShort(6, (short)versionTo);
        }
    }

    public static ClassReader readAndPatchClass(InputStream in) throws IOException {
        return new ClassReader(in);
    }
}

