/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.AsmUtils;
import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.ClassMetadata;
import de.thetaphi.forbiddenapis.ClassPatternRule;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.Logger;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.RelatedClassLookup;
import de.thetaphi.forbiddenapis.VersionCompare;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Signatures
implements Constants {
    private static final String BUNDLED_PREFIX = "@includeBundled ";
    private static final String DEFAULT_MESSAGE_PREFIX = "@defaultMessage ";
    private static final String IGNORE_UNRESOLVABLE_LINE = "@ignoreUnresolvable";
    private static final String IGNORE_MISSING_CLASSES_LINE = "@ignoreMissingClasses";
    private static final String WILDCARD_ARGS = "**";
    private static final Pattern PATTERN_WILDCARD_ARGS = Pattern.compile(String.format(Locale.ROOT, "%s\\s*%s\\s*%s", Pattern.quote("("), Pattern.quote("**"), Pattern.quote(")")));
    private static final NavigableSet<String> BUNDLED_SIGNATURES_NAMES;
    private final RelatedClassLookup lookup;
    private final Logger logger;
    private final boolean failOnUnresolvableSignatures;
    private final boolean ignoreSignaturesOfMissingClasses;
    final Map<String, String> signatures = new HashMap<String, String>();
    final Set<ClassPatternRule> classPatterns = new LinkedHashSet<ClassPatternRule>();
    final Map<String, Checker.ViolationSeverity> severityPerSignature = new HashMap<String, Checker.ViolationSeverity>();
    final Map<Pattern, Checker.ViolationSeverity> severityPerClassPattern = new HashMap<Pattern, Checker.ViolationSeverity>();
    private boolean forbidNonPortableRuntime = false;
    private int numberOfFiles = 0;
    private boolean failOnViolation;

    public Signatures(Checker checker) {
        this(checker, checker.logger, checker.options.contains((Object)Checker.Option.IGNORE_SIGNATURES_OF_MISSING_CLASSES), checker.options.contains((Object)Checker.Option.FAIL_ON_UNRESOLVABLE_SIGNATURES), checker.options.contains((Object)Checker.Option.FAIL_ON_VIOLATION));
    }

    public Signatures(RelatedClassLookup lookup, Logger logger, boolean ignoreSignaturesOfMissingClasses, boolean failOnUnresolvableSignatures, boolean failOnViolation) {
        this.lookup = lookup;
        this.logger = logger;
        this.ignoreSignaturesOfMissingClasses = ignoreSignaturesOfMissingClasses;
        this.failOnUnresolvableSignatures = failOnUnresolvableSignatures;
        this.failOnViolation = failOnViolation;
    }

    static String getKey(String internalClassName) {
        return "c\u0000" + internalClassName;
    }

    static String getKey(String internalClassName, String field) {
        return "f\u0000" + internalClassName + '\u0000' + field;
    }

    static String getKey(String internalClassName, Method method) {
        return "m\u0000" + internalClassName + '\u0000' + method;
    }

    private void addSignature(String line, String defaultMessage, UnresolvableReporting report, boolean localIgnoreMissingClasses, Set<String> missingClasses) throws ParseException, IOException {
        String signature;
        String message = null;
        int p = line.indexOf(64);
        if (p >= 0) {
            signature = line.substring(0, p).trim();
            message = line.substring(p + 1).trim();
        } else {
            signature = line;
            message = defaultMessage;
        }
        if (line.isEmpty()) {
            throw new ParseException("Empty signature");
        }
        if (message != null && message.isEmpty()) {
            message = null;
        }
        String printout = message != null ? signature + " [" + message + "]" : signature;
        Collection<String> keys = this.getKeys(report, localIgnoreMissingClasses, missingClasses, signature);
        if (keys != null) {
            for (String key : keys) {
                if (key.startsWith("c\u0000") || key.startsWith("f\u0000") || key.startsWith("m\u0000")) {
                    this.signatures.put(key, printout);
                    continue;
                }
                this.classPatterns.add(new ClassPatternRule(key, message));
            }
        }
    }

    private Collection<String> getKeys(UnresolvableReporting report, boolean localIgnoreMissingClasses, Set<String> missingClasses, String signature) throws ParseException, IOException {
        ClassMetadata c;
        String field;
        Method method;
        String clazz;
        int p = signature.indexOf(35);
        if (p >= 0) {
            clazz = signature.substring(0, p);
            String methodOrField = signature.substring(p + 1);
            if ((p = methodOrField.indexOf(40)) >= 0) {
                if (p == 0) {
                    throw new ParseException("Invalid method signature (method name missing): " + signature);
                }
                if (PATTERN_WILDCARD_ARGS.matcher(methodOrField.substring(p)).matches()) {
                    method = new Method(methodOrField.substring(0, p).trim(), WILDCARD_ARGS);
                } else {
                    try {
                        method = Method.getMethod("void ".concat(methodOrField), true);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ParseException("Invalid method signature: " + signature);
                    }
                }
                field = null;
            } else {
                field = methodOrField;
                method = null;
            }
        } else {
            clazz = signature;
            method = null;
            field = null;
        }
        if (AsmUtils.isGlob(clazz)) {
            if (method != null || field != null) {
                throw new ParseException(String.format(Locale.ENGLISH, "Class level glob pattern cannot be combined with methods/fields: %s", signature));
            }
            return Collections.singleton(clazz);
        }
        ArrayList<String> keys = new ArrayList<String>();
        try {
            c = this.lookup.getClassFromClassLoader(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.ignoreSignaturesOfMissingClasses || localIgnoreMissingClasses) {
                return null;
            }
            if (report.reportClassNotFound) {
                report.parseFailed(this.logger, String.format(Locale.ENGLISH, "Class '%s' not found on classpath", cnfe.getMessage()), signature);
            } else {
                missingClasses.add(clazz);
            }
            return null;
        }
        if (method != null) {
            assert (field == null);
            boolean found = false;
            for (Method m : c.methods) {
                if (!m.getName().equals(method.getName()) || !WILDCARD_ARGS.equals(method.getDescriptor()) && !Arrays.equals(m.getArgumentTypes(), method.getArgumentTypes())) continue;
                found = true;
                keys.add(Signatures.getKey(c.className, m));
            }
            if (!found) {
                report.parseFailed(this.logger, "Method not found", signature);
                return null;
            }
        } else if (field != null) {
            assert (method == null);
            if (!c.fields.contains(field)) {
                report.parseFailed(this.logger, "Field not found", signature);
                return null;
            }
            keys.add(Signatures.getKey(c.className, field));
        } else {
            assert (field == null && method == null);
            keys.add(Signatures.getKey(c.className));
        }
        return keys;
    }

    private void reportMissingSignatureClasses(Set<String> missingClasses) {
        if (missingClasses.isEmpty()) {
            return;
        }
        this.logger.warn("Some signatures were ignored because the following classes were not found on classpath:");
        this.logger.warn(AsmUtils.formatClassesAbbreviated(missingClasses));
    }

    private void addBundledSignatures(String name, String jdkTargetVersion, boolean readExternal, Set<String> missingClasses) throws IOException, ParseException {
        URL url;
        if (!name.matches("[A-Za-z0-9\\-\\.]+")) {
            throw new ParseException("Invalid bundled signature reference: " + name);
        }
        if ("jdk-non-portable".equals(name)) {
            if (readExternal) {
                this.logger.info("Reading bundled API signatures: " + name);
            }
            ++this.numberOfFiles;
            this.forbidNonPortableRuntime = true;
            return;
        }
        if (readExternal) {
            String closest;
            Matcher m;
            if (!BUNDLED_SIGNATURES_NAMES.contains(name = Signatures.fixTargetVersion(name)) && jdkTargetVersion != null && name.startsWith("jdk-") && !ENDS_WITH_VERSION_PATTERN.matcher(name).matches()) {
                name = name + "-" + jdkTargetVersion;
                name = Signatures.fixTargetVersion(name);
            }
            if ((m = ENDS_WITH_VERSION_PATTERN.matcher(name)).matches() && (closest = BUNDLED_SIGNATURES_NAMES.floor(name)) != null && closest.startsWith(m.group(1)) && ENDS_WITH_VERSION_PATTERN.matcher(closest).matches()) {
                if (VersionCompare.compareBundledSignatures(closest, name) != 0) {
                    this.logger.warn("Bundled signatures '" + name + "' not found, choosing next lower available signature: " + closest);
                }
                name = closest;
            }
            if (!BUNDLED_SIGNATURES_NAMES.contains(name)) {
                throw new FileNotFoundException("Bundled signatures resource not found: " + name);
            }
            this.logger.info("Reading bundled API signatures: " + name);
        }
        if ((url = Checker.class.getResource("signatures/" + name + ".txt")) == null) {
            throw new FileNotFoundException("Bundled signatures resource not found: " + name);
        }
        this.parseSignaturesStream(url.openStream(), true, missingClasses);
    }

    private void parseSignaturesStream(InputStream in, boolean isBundled, Set<String> missingClasses) throws IOException, ParseException {
        this.parseSignaturesFile(new InputStreamReader(in, StandardCharsets.UTF_8), isBundled, missingClasses);
    }

    private void parseSignaturesFile(Reader reader, boolean isBundled, Set<String> missingClasses) throws IOException, ParseException {
        ++this.numberOfFiles;
        try (BufferedReader r = new BufferedReader(reader);){
            String line;
            String defaultMessage = null;
            UnresolvableReporting reporter = this.failOnUnresolvableSignatures ? UnresolvableReporting.FAIL : UnresolvableReporting.WARNING;
            boolean localIgnoreMissingClasses = false;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("@")) {
                    if (isBundled && line.startsWith(BUNDLED_PREFIX)) {
                        String name = line.substring(BUNDLED_PREFIX.length()).trim();
                        this.addBundledSignatures(name, null, false, missingClasses);
                        continue;
                    }
                    if (line.startsWith(DEFAULT_MESSAGE_PREFIX)) {
                        defaultMessage = line.substring(DEFAULT_MESSAGE_PREFIX.length()).trim();
                        if (defaultMessage.length() != 0) continue;
                        defaultMessage = null;
                        continue;
                    }
                    if (line.equals(IGNORE_UNRESOLVABLE_LINE)) {
                        if (isBundled) {
                            reporter = UnresolvableReporting.SILENT;
                            continue;
                        }
                        this.logger.warn(String.format(Locale.ENGLISH, "'%s' inside signatures files is deprecated, prefer using '%s' to ignore signatures where the class is missing.", IGNORE_UNRESOLVABLE_LINE, IGNORE_MISSING_CLASSES_LINE));
                        reporter = UnresolvableReporting.WARNING;
                        continue;
                    }
                    if (line.equals(IGNORE_MISSING_CLASSES_LINE)) {
                        localIgnoreMissingClasses = true;
                        continue;
                    }
                    throw new ParseException("Invalid line in signature file: " + line);
                }
                this.addSignature(line, defaultMessage, reporter, localIgnoreMissingClasses, missingClasses);
            }
        }
    }

    public void addBundledSignatures(String name, String jdkTargetVersion) throws IOException, ParseException {
        TreeSet<String> missingClasses = new TreeSet<String>();
        this.addBundledSignatures(name, jdkTargetVersion, true, missingClasses);
        this.reportMissingSignatureClasses(missingClasses);
    }

    public void parseSignaturesStream(InputStream in, String name) throws IOException, ParseException {
        this.logger.info("Reading API signatures: " + name);
        TreeSet<String> missingClasses = new TreeSet<String>();
        this.parseSignaturesStream(in, false, missingClasses);
        this.reportMissingSignatureClasses(missingClasses);
    }

    public void parseSignaturesString(String signatures) throws IOException, ParseException {
        this.logger.info("Reading inline API signatures...");
        TreeSet<String> missingClasses = new TreeSet<String>();
        this.parseSignaturesFile(new StringReader(signatures), false, missingClasses);
        this.reportMissingSignatureClasses(missingClasses);
    }

    public boolean hasNoSignatures() {
        return 0 == this.signatures.size() + this.classPatterns.size() + (this.forbidNonPortableRuntime ? 1 : 0);
    }

    public boolean noSignaturesFilesParsed() {
        return this.numberOfFiles == 0;
    }

    public void setSignaturesSeverity(Collection<String> signatures, Checker.ViolationSeverity severity) throws ParseException, IOException {
        this.logger.info("Adjusting severity to " + (Object)((Object)severity) + " for " + signatures.size() + " signatures...");
        for (String s : signatures) {
            this.setSignatureSeverity(s, severity);
        }
    }

    public void setSignatureSeverity(String signature, Checker.ViolationSeverity severity) throws ParseException, IOException {
        Collection<String> keys = this.getKeys(UnresolvableReporting.SILENT, false, new HashSet<String>(), signature);
        if (keys != null) {
            for (String key : keys) {
                if (key.startsWith("c\u0000") || key.startsWith("f\u0000") || key.startsWith("m\u0000")) {
                    this.severityPerSignature.put(key, severity);
                    continue;
                }
                this.severityPerClassPattern.put(AsmUtils.glob2Pattern(key), severity);
            }
        }
    }

    public boolean isNonPortableRuntimeForbidden() {
        return this.forbidNonPortableRuntime;
    }

    private static String formatTypePrintout(String printout, String what) {
        return String.format(Locale.ENGLISH, "Forbidden %s use: %s", what, printout);
    }

    public ViolationResult checkType(Type type, String what) {
        if (type.getSort() != 10) {
            return null;
        }
        String key = Signatures.getKey(type.getInternalName());
        String printout = this.signatures.get(Signatures.getKey(type.getInternalName()));
        if (printout != null) {
            return new ViolationResult(Signatures.formatTypePrintout(printout, what), this.getSeverityForKey(key));
        }
        String binaryClassName = type.getClassName();
        for (ClassPatternRule r : this.classPatterns) {
            if (!r.matches(binaryClassName)) continue;
            return new ViolationResult(Signatures.formatTypePrintout(r.getPrintout(binaryClassName), what), this.getSeverityForClassName(binaryClassName));
        }
        return null;
    }

    public ViolationResult checkMethod(String internalClassName, Method method) {
        String key = Signatures.getKey(internalClassName, method);
        String printout = this.signatures.get(key);
        return printout == null ? null : new ViolationResult("Forbidden method invocation: ".concat(printout), this.getSeverityForKey(key));
    }

    public ViolationResult checkField(String internalClassName, String field) {
        String key = Signatures.getKey(internalClassName, field);
        String printout = this.signatures.get(key);
        return printout == null ? null : new ViolationResult("Forbidden field access: ".concat(printout), this.getSeverityForKey(key));
    }

    private Checker.ViolationSeverity getSeverityForKey(String key) {
        Checker.ViolationSeverity severity = this.severityPerSignature.get(key);
        return severity != null ? severity : (this.failOnViolation ? Checker.ViolationSeverity.ERROR : Checker.ViolationSeverity.WARNING);
    }

    private Checker.ViolationSeverity getSeverityForClassName(String className) {
        for (Map.Entry<Pattern, Checker.ViolationSeverity> e : this.severityPerClassPattern.entrySet()) {
            if (!e.getKey().matcher(className).matches()) continue;
            return e.getValue();
        }
        return this.failOnViolation ? Checker.ViolationSeverity.ERROR : Checker.ViolationSeverity.WARNING;
    }

    public static String fixTargetVersion(String name) throws ParseException {
        Matcher m = JDK_SIG_PATTERN.matcher(name);
        if (m.matches()) {
            if (m.group(4) == null) {
                int minor;
                String prefix = m.group(1);
                int major = Integer.parseInt(m.group(2));
                int n = minor = m.group(3) != null ? Integer.parseInt(m.group(3).substring(1)) : 0;
                if (major == 1 && minor >= 1 && minor < 9) {
                    return prefix + "1." + minor;
                }
                if (major > 1 && major < 9) {
                    if (minor == 0) {
                        return prefix + "1." + major;
                    }
                } else {
                    if (major >= 9 && minor > 0) {
                        return prefix + major + "." + minor;
                    }
                    if (major >= 9 && minor == 0) {
                        return prefix + major;
                    }
                }
            }
            throw new ParseException("Invalid bundled signature reference (JDK version is invalid): " + name);
        }
        return name;
    }

    static {
        try (InputStream in = Checker.class.getResourceAsStream("signatures/list");
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String name;
            TreeSet<String> names = new TreeSet<String>(VersionCompare.BUNDLED_SIGNATURES_COMPARATOR);
            while ((name = reader.readLine()) != null) {
                names.add(name);
            }
            BUNDLED_SIGNATURES_NAMES = names;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static class ViolationResult {
        public final String message;
        public final Checker.ViolationSeverity severity;

        public ViolationResult(String message, Checker.ViolationSeverity severity) {
            this.message = message;
            this.severity = severity;
        }
    }

    private static enum UnresolvableReporting {
        FAIL(true){

            @Override
            public void parseFailed(Logger logger, String message, String signature) throws ParseException {
                throw new ParseException(String.format(Locale.ENGLISH, "%s while parsing signature: %s", message, signature));
            }
        }
        ,
        WARNING(false){

            @Override
            public void parseFailed(Logger logger, String message, String signature) throws ParseException {
                logger.warn(String.format(Locale.ENGLISH, "%s while parsing signature: %s [signature ignored]", message, signature));
            }
        }
        ,
        SILENT(true){

            @Override
            public void parseFailed(Logger logger, String message, String signature) throws ParseException {
            }
        };

        public final boolean reportClassNotFound;

        private UnresolvableReporting(boolean reportClassNotFound) {
            this.reportClassNotFound = reportClassNotFound;
        }

        public abstract void parseFailed(Logger var1, String var2, String var3) throws ParseException;
    }
}

