/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis.cli;

import de.thetaphi.forbiddenapis.AsmUtils;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.Logger;
import de.thetaphi.forbiddenapis.StdIoLogger;
import de.thetaphi.forbiddenapis.cli.ExitException;
import de.thetaphi.forbiddenapis.commons.cli.CommandLine;
import de.thetaphi.forbiddenapis.commons.cli.DefaultParser;
import de.thetaphi.forbiddenapis.commons.cli.HelpFormatter;
import de.thetaphi.forbiddenapis.commons.cli.Option;
import de.thetaphi.forbiddenapis.commons.cli.OptionGroup;
import de.thetaphi.forbiddenapis.commons.cli.Options;
import de.thetaphi.forbiddenapis.commons.cli.ParseException;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;

public final class CliMain
implements Constants {
    private final Logger logger;
    private final Option classpathOpt;
    private final Option dirOpt;
    private final Option includesOpt;
    private final Option excludesOpt;
    private final Option signaturesfileOpt;
    private final Option bundledsignaturesOpt;
    private final Option signatureswithseveritysuppressOpt;
    private final Option signatureswithseveritywarnOpt;
    private final Option suppressannotationsOpt;
    private final Option allowmissingclassesOpt;
    private final Option ignoresignaturesofmissingclassesOpt;
    private final Option allowunresolvablesignaturesOpt;
    private final Option versionOpt;
    private final Option helpOpt;
    private final Option debugOpt;
    private final CommandLine cmd;
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_VIOLATION = 1;
    public static final int EXIT_ERR_CMDLINE = 2;
    public static final int EXIT_UNSUPPORTED_JDK = 3;
    public static final int EXIT_ERR_OTHER = 4;

    public CliMain(String ... args) throws ExitException {
        OptionGroup required = new OptionGroup();
        required.setRequired(true);
        this.dirOpt = Option.builder("d").desc("directory (or jar file) with class files to check for forbidden api usage; this directory is also added to classpath").longOpt("dir").hasArg().argName("directory").build();
        required.addOption(this.dirOpt);
        this.versionOpt = Option.builder("V").desc("print product version and exit").longOpt("version").build();
        required.addOption(this.versionOpt);
        this.helpOpt = Option.builder("h").desc("print this help").longOpt("help").build();
        required.addOption(this.helpOpt);
        Options options = new Options();
        options.addOptionGroup(required);
        this.debugOpt = Option.builder().desc("enable debug logging (stderr)").longOpt("debug").build();
        options.addOption(this.debugOpt);
        this.classpathOpt = Option.builder("c").desc("class search path of directories and zip/jar files").longOpt("classpath").hasArgs().valueSeparator(File.pathSeparatorChar).argName("path").build();
        options.addOption(this.classpathOpt);
        this.includesOpt = Option.builder("i").desc("ANT-style pattern to select class files (separated by commas or option can be given multiple times, defaults to '**/*.class')").longOpt("includes").hasArgs().valueSeparator(',').argName("pattern").build();
        options.addOption(this.includesOpt);
        this.excludesOpt = Option.builder("e").desc("ANT-style pattern to exclude some files from checks (separated by commas or option can be given multiple times)").longOpt("excludes").hasArgs().valueSeparator(',').argName("pattern").build();
        options.addOption(this.excludesOpt);
        this.signaturesfileOpt = Option.builder("f").desc("path to a file containing signatures (option can be given multiple times)").longOpt("signaturesfile").hasArg().argName("file").build();
        options.addOption(this.signaturesfileOpt);
        this.bundledsignaturesOpt = Option.builder("b").desc("name of a bundled signatures definition (separated by commas or option can be given multiple times)").longOpt("bundledsignatures").hasArgs().valueSeparator(',').argName("name").build();
        options.addOption(this.bundledsignaturesOpt);
        this.signatureswithseveritysuppressOpt = Option.builder().desc("forbidden API signature for which violations should not be reported at all (separated by commas or option can be given multiple times)").longOpt("signatureswithseveritysuppress").hasArgs().valueSeparator(',').argName("name").build();
        options.addOption(this.signatureswithseveritysuppressOpt);
        this.signatureswithseveritywarnOpt = Option.builder().desc("forbidden API signature for which violations just be reported at warn level but not lead to a non-success exit code (separated by commas or option can be given multiple times)").longOpt("signatureswithseveritywarn").hasArgs().valueSeparator(',').argName("name").build();
        options.addOption(this.signatureswithseveritywarnOpt);
        this.suppressannotationsOpt = Option.builder().desc("class name or glob pattern of annotation that suppresses error reporting in classes/methods/fields (separated by commas or option can be given multiple times)").longOpt("suppressannotation").hasArgs().valueSeparator(',').argName("classname").build();
        options.addOption(this.suppressannotationsOpt);
        this.allowmissingclassesOpt = Option.builder().desc("don't fail if a referenced class is missing on classpath").longOpt("allowmissingclasses").build();
        options.addOption(this.allowmissingclassesOpt);
        this.ignoresignaturesofmissingclassesOpt = Option.builder().desc("if a class is missing while parsing signatures files, all methods and fields from this class are silently ignored").longOpt("ignoresignaturesofmissingclasses").build();
        options.addOption(this.ignoresignaturesofmissingclassesOpt);
        this.allowunresolvablesignaturesOpt = Option.builder().desc("DEPRECATED: don't fail if a signature is not resolving").longOpt("allowunresolvablesignatures").build();
        options.addOption(this.allowunresolvablesignaturesOpt);
        try {
            this.cmd = new DefaultParser().parse(options, args);
            boolean debugLogging = this.cmd.hasOption(this.debugOpt.getLongOpt());
            Logger logger = this.logger = debugLogging ? StdIoLogger.INSTANCE_DEBUG : StdIoLogger.INSTANCE;
            if (this.cmd.hasOption(this.helpOpt.getLongOpt())) {
                this.printHelp(options);
                throw new ExitException(0);
            }
            if (this.cmd.hasOption(this.versionOpt.getLongOpt())) {
                this.printVersion();
                throw new ExitException(0);
            }
        }
        catch (ParseException pe) {
            if (args.length > 0) {
                StdIoLogger.INSTANCE.error(pe.getMessage());
            }
            this.printHelp(options);
            throw new ExitException(2);
        }
    }

    private void printVersion() {
        Package pkg = this.getClass().getPackage();
        this.logger.info(String.format(Locale.ENGLISH, "%s %s", pkg.getImplementationTitle(), pkg.getImplementationVersion()));
    }

    private void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String clazzName = this.getClass().getName();
        String cmdline = "java " + clazzName;
        try {
            URL jarUrl;
            URLConnection conn = this.getClass().getClassLoader().getResource(AsmUtils.getClassResourceName(clazzName)).openConnection();
            if (conn instanceof JarURLConnection && "file".equalsIgnoreCase((jarUrl = ((JarURLConnection)conn).getJarFileURL()).getProtocol())) {
                String cwd = new File(".").getCanonicalPath();
                String path = new File(jarUrl.toURI()).getCanonicalPath();
                cmdline = "java -jar " + (path.startsWith(cwd) ? path.substring(cwd.length() + File.separator.length()) : path);
            }
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        formatter.printHelp(cmdline + " [options]", "Scans a set of class files for forbidden API usage.", options, String.format(Locale.ENGLISH, "Exit codes: %d = SUCCESS, %d = forbidden API detected, %d = invalid command line, %d = unsupported JDK version, %d = other error (I/O,...)", 0, 1, 2, 3, 4));
    }

    /*
     * Exception decompiling
     */
    public void run() throws ExitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [38[UNCONDITIONALDOLOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String normalizePattern(String pattern) {
        if ((pattern = CliMain.normalizePath(pattern)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    private static String normalizePath(String name) {
        return name.trim().replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static void main(String ... args) {
        block3: {
            try {
                new CliMain(args).run();
            }
            catch (ExitException e) {
                if (e.getMessage() != null) {
                    StdIoLogger.INSTANCE.error(e.getMessage());
                }
                if (e.exitCode == 0) break block3;
                System.exit(e.exitCode);
            }
        }
    }
}

