/*
 * Decompiled with CFR 0.152.
 */
package omc;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import omc.LoadLibraryException;
import omc.corba.OMCInterface;
import omc.corba.Result;
import omc.corba.ScriptingHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHandler {
    public static final String importFileName = "package.imports";
    private static final String packageFileName = "package.mo";
    private final Logger log = LoggerFactory.getLogger(ImportHandler.class);
    private final Path importFile;
    private final List<Pair<String, Path>> importedLibs = new ArrayList<Pair<String, Path>>();

    public ImportHandler(Path projectFile) {
        if (projectFile.endsWith(packageFileName)) {
            projectFile = projectFile.getParent();
        }
        if (Files.isDirectory(projectFile, new LinkOption[0])) {
            this.importFile = projectFile.resolve(importFileName);
        } else {
            if (!projectFile.endsWith(importFileName)) {
                throw new IllegalArgumentException("The given projectFile has to end with: package.imports");
            }
            this.importFile = projectFile;
        }
        this.log.info("Using file: {}", (Object)this.importFile);
    }

    List<Path> relativeImports(Path file) throws IOException {
        Path parent = file.getParent();
        if (Files.exists(file, new LinkOption[0])) {
            return Files.lines(file).map(parent::resolve).collect(Collectors.toList());
        }
        return new ArrayList<Path>();
    }

    public void loadLibraries(OMCInterface omc) throws IOException, LoadLibraryException {
        List<Path> libraries = this.relativeImports(this.importFile);
        this.log.debug("Loading {}", libraries);
        List<String> errors = libraries.stream().map(lib -> {
            try {
                return this.loadLibrary(omc, (Path)lib) ? "" : "Couldn't load library " + lib;
            }
            catch (FileNotFoundException e) {
                return e.getMessage();
            }
        }).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new LoadLibraryException("Couldn't load all libraries", errors);
        }
    }

    boolean loadLibrary(OMCInterface omc, Path packageFile) throws FileNotFoundException {
        if (Files.notExists(packageFile = packageFile.toAbsolutePath().normalize(), new LinkOption[0])) {
            throw new FileNotFoundException("The library " + packageFile + " does not exist");
        }
        Result res = omc.call("loadFile", ScriptingHelper.convertPath(packageFile));
        this.log.debug("Loading {} returned {}", (Object)packageFile, (Object)res);
        if (res.result.equals("true")) {
            res = omc.call("getLoadedLibraries", new Object[0]);
            List libs = ScriptingHelper.fromNestedArrayToNestedList(res.result).stream().map(o -> {
                List l = (List)o;
                return new ImmutablePair((Object)((String)l.get(0)), (Object)Paths.get((String)l.get(1), new String[0]));
            }).collect(Collectors.toList());
            for (Pair p : libs) {
                if (!((Path)p.getValue()).equals(packageFile.getParent())) continue;
                if (this.importedLibs.contains(p)) break;
                this.importedLibs.add((Pair<String, Path>)p);
                break;
            }
            return true;
        }
        return false;
    }

    public List<Pair<String, Path>> getImportedLibs() {
        return this.importedLibs;
    }
}

