/*
 * Decompiled with CFR 0.152.
 */
package version;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Version
implements Comparable<Version> {
    protected final String rawString;
    protected final Optional<Integer> major;
    protected final Optional<Integer> minor;
    protected final Optional<Integer> patch;
    public final Boolean isDevVersion;
    protected final Logger log = LoggerFactory.getLogger(Version.class);

    protected Version(String raw) {
        this.rawString = raw;
        List numbers = this.parseVersion(this.rawString).stream().map(Optional::of).collect(Collectors.toList());
        Optional mj = Optional.empty();
        Optional mi = Optional.empty();
        Optional pt = Optional.empty();
        for (int i = 0; i < numbers.size(); ++i) {
            if (i == 0) {
                mj = (Optional)numbers.get(i);
                continue;
            }
            if (i == 1) {
                mi = (Optional)numbers.get(i);
                continue;
            }
            if (i != 2) continue;
            pt = (Optional)numbers.get(i);
        }
        this.major = mj;
        this.minor = mi;
        this.patch = pt;
        this.isDevVersion = this.parseDevVersion(this.rawString);
        this.log.debug("raw: {} - major: {} minor: {} patch: {} isDev: {}", new Object[]{this.rawString, this.major, this.minor, this.patch, this.isDevVersion});
    }

    public String getRaw() {
        return this.rawString;
    }

    protected abstract List<Integer> parseVersion(String var1);

    protected abstract Boolean parseDevVersion(String var1);

    @Override
    public int compareTo(Version v) {
        Function<Integer, Integer> mul100 = i -> i * 100;
        Function<Integer, Integer> mul10 = i -> i * 10;
        Integer thisMji = this.major.map(mul100).orElse(0);
        Integer thisMii = this.minor.map(mul10).orElse(0);
        Integer thisPti = this.patch.orElse(0);
        Integer thisVersion = thisMji + thisMii + thisPti;
        Integer thatMji = v.major.map(mul100).orElse(0);
        Integer thatMii = v.minor.map(mul10).orElse(0);
        Integer thatPti = v.patch.orElse(0);
        Integer thatVersion = thatMji + thatMii + thatPti;
        return thisVersion.compareTo(thatVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.rawString.equals(version.rawString);
    }

    public int hashCode() {
        return this.rawString.hashCode();
    }

    public String toString() {
        Function<Integer, String> asString = i -> i.toString();
        Function<Integer, String> withDot = i -> "." + i.toString();
        return "V " + this.major.map(asString).orElse("") + this.minor.map(withDot).orElse("") + this.patch.map(withDot).orElse("");
    }

    static List<Integer> extractNumbers(Matcher matcher) {
        matcher.find();
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            String str = matcher.group(i);
            if (str == null) continue;
            versions.add(Integer.parseInt(str));
        }
        return versions;
    }
}

