/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import de.thomaskrille.dropwizard_template_config.EnvironmentProvider;
import de.thomaskrille.dropwizard_template_config.SystemPropertiesProvider;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.Configuration;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.Template;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateExceptionHandler;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Properties;

public class TemplateConfigurationSourceProvider
implements ConfigurationSourceProvider {
    private final Charset charset;
    private final Optional<String> resourceIncludePath;
    private final Optional<String> fileIncludePath;
    private final Optional<String> outputPath;
    private final SystemPropertiesProvider systemPropertiesProvider;
    private final ConfigurationSourceProvider parentProvider;
    private final EnvironmentProvider environmentProvider;

    TemplateConfigurationSourceProvider(ConfigurationSourceProvider parentProvider, EnvironmentProvider environmentProvider, SystemPropertiesProvider systemPropertiesProvider, Charset charset, Optional<String> resourceIncludePath, Optional<String> fileIncludePath, Optional<String> outputPath) {
        this.parentProvider = parentProvider;
        this.environmentProvider = environmentProvider;
        this.systemPropertiesProvider = systemPropertiesProvider;
        this.charset = charset;
        this.resourceIncludePath = resourceIncludePath;
        this.fileIncludePath = fileIncludePath;
        this.outputPath = outputPath;
    }

    public InputStream open(String path) throws IOException {
        try {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            configuration.setNumberFormat("computer");
            configuration.setDefaultEncoding(this.charset.name());
            if (this.resourceIncludePath.isPresent()) {
                String includePath = (String)this.resourceIncludePath.get();
                if (!includePath.startsWith("/")) {
                    includePath = "/" + includePath;
                }
                configuration.setClassForTemplateLoading(this.getClass(), includePath);
            } else if (this.fileIncludePath.isPresent()) {
                File includeDir = new File((String)this.fileIncludePath.get());
                configuration.setDirectoryForTemplateLoading(includeDir);
            }
            HashMap<String, Object> dataModel = new HashMap<String, Object>();
            Properties systemProperties = this.systemPropertiesProvider.getSystemProperties();
            for (String propertyName : systemProperties.stringPropertyNames()) {
                dataModel.put(propertyName, systemProperties.getProperty(propertyName));
            }
            dataModel.putAll(this.environmentProvider.getEnvironment());
            dataModel.put("env", this.environmentProvider.getEnvironment());
            dataModel.put("sys", this.systemPropertiesProvider.getSystemProperties());
            ByteArrayOutputStream processedTemplateStream = new ByteArrayOutputStream();
            InputStreamReader configTemplate = new InputStreamReader(this.parentProvider.open(path), this.charset);
            new Template("config", configTemplate, configuration).process(dataModel, new OutputStreamWriter((OutputStream)processedTemplateStream, this.charset));
            byte[] processedTemplateBytes = processedTemplateStream.toByteArray();
            if (this.outputPath.isPresent()) {
                File outputFile = new File((String)this.outputPath.get());
                Files.createParentDirs((File)outputFile);
                Files.write((byte[])processedTemplateBytes, (File)outputFile);
            }
            return new ByteArrayInputStream(processedTemplateBytes);
        }
        catch (TemplateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

