/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.cache;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.cache.CacheStorageWithGetSize;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.cache.ConcurrentCacheStorage;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core._ConcurrentMapFactory;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility.UndeclaredThrowableException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class SoftCacheStorage
implements ConcurrentCacheStorage,
CacheStorageWithGetSize {
    private static final Method atomicRemove = SoftCacheStorage.getAtomicRemoveMethod();
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Map map;
    private final boolean concurrent;

    public SoftCacheStorage() {
        this(_ConcurrentMapFactory.newMaybeConcurrentHashMap());
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public SoftCacheStorage(Map backingMap) {
        this.map = backingMap;
        this.concurrent = _ConcurrentMapFactory.isConcurrent(this.map);
    }

    public Object get(Object key) {
        this.processQueue();
        Reference ref = (Reference)this.map.get(key);
        return ref == null ? null : ref.get();
    }

    public void put(Object key, Object value) {
        this.processQueue();
        this.map.put(key, new SoftValueReference(key, value, this.queue));
    }

    public void remove(Object key) {
        this.processQueue();
        this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
        this.processQueue();
    }

    public int getSize() {
        this.processQueue();
        return this.map.size();
    }

    private void processQueue() {
        SoftValueReference ref;
        while ((ref = (SoftValueReference)this.queue.poll()) != null) {
            Object key = ref.getKey();
            if (this.concurrent) {
                try {
                    atomicRemove.invoke((Object)this.map, key, ref);
                }
                catch (IllegalAccessException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (InvocationTargetException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            if (this.map.get(key) != ref) continue;
            this.map.remove(key);
        }
        return;
    }

    private static Method getAtomicRemoveMethod() {
        try {
            return Class.forName("java.util.concurrent.ConcurrentMap").getMethod("remove", Object.class, Object.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static final class SoftValueReference
    extends SoftReference {
        private final Object key;

        SoftValueReference(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }

        Object getKey() {
            return this.key;
        }
    }
}

