/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.cache;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.cache.TemplateLoader;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.cache.TemplateLoaderUtils;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.cache.URLTemplateSource;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.log.Logger;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility.CollectionUtils;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;

public class WebappTemplateLoader
implements TemplateLoader {
    private static final Logger LOG = Logger.getLogger("de.thomaskrille.dropwizard_template_config.redist.freemarker.cache");
    private final ServletContext servletContext;
    private final String subdirPath;
    private Boolean urlConnectionUsesCaches;

    public WebappTemplateLoader(ServletContext servletContext) {
        this(servletContext, "/");
    }

    public WebappTemplateLoader(ServletContext servletContext, String subdirPath) {
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext == null");
        }
        if (subdirPath == null) {
            throw new IllegalArgumentException("path == null");
        }
        if (!(subdirPath = subdirPath.replace('\\', '/')).endsWith("/")) {
            subdirPath = subdirPath + "/";
        }
        if (!subdirPath.startsWith("/")) {
            subdirPath = "/" + subdirPath;
        }
        this.subdirPath = subdirPath;
        this.servletContext = servletContext;
    }

    public Object findTemplateSource(String name) throws IOException {
        String fullPath = this.subdirPath + name;
        try {
            String realPath = this.servletContext.getRealPath(fullPath);
            if (realPath != null) {
                File file = new File(realPath);
                if (!file.isFile()) {
                    return null;
                }
                if (file.canRead()) {
                    return file;
                }
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        URL url = null;
        try {
            url = this.servletContext.getResource(fullPath);
        }
        catch (MalformedURLException e) {
            LOG.warn("Could not retrieve resource " + StringUtil.jQuoteNoXSS(fullPath), e);
            return null;
        }
        return url == null ? null : new URLTemplateSource(url, this.getURLConnectionUsesCaches());
    }

    public long getLastModified(Object templateSource) {
        if (templateSource instanceof File) {
            return ((File)templateSource).lastModified();
        }
        return ((URLTemplateSource)templateSource).lastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (templateSource instanceof File) {
            return new InputStreamReader((InputStream)new FileInputStream((File)templateSource), encoding);
        }
        return new InputStreamReader(((URLTemplateSource)templateSource).getInputStream(), encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        if (!(templateSource instanceof File)) {
            ((URLTemplateSource)templateSource).close();
        }
    }

    public Boolean getURLConnectionUsesCaches() {
        return this.urlConnectionUsesCaches;
    }

    public void setURLConnectionUsesCaches(Boolean urlConnectionUsesCaches) {
        this.urlConnectionUsesCaches = urlConnectionUsesCaches;
    }

    public String toString() {
        return TemplateLoaderUtils.getClassNameForToString(this) + "(subdirPath=" + StringUtil.jQuote(this.subdirPath) + ", servletContext={contextPath=" + StringUtil.jQuote(this.getContextPath()) + ", displayName=" + StringUtil.jQuote(this.servletContext.getServletContextName()) + "})";
    }

    private String getContextPath() {
        try {
            Method m = this.servletContext.getClass().getMethod("getContextPath", CollectionUtils.EMPTY_CLASS_ARRAY);
            return (String)m.invoke((Object)this.servletContext, CollectionUtils.EMPTY_OBJECT_ARRAY);
        }
        catch (Throwable e) {
            return "[can't query before Serlvet 2.5]";
        }
    }
}

