/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.core;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.Configuration;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.Version;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility.DateUtil;

public class CommandLine {
    public static void main(String[] args) {
        Version ver = Configuration.getVersion();
        System.out.println();
        System.out.print("FreeMarker version ");
        System.out.print(ver);
        if (!ver.toString().endsWith("Z") && ver.getBuildDate() != null) {
            System.out.print(" (built on ");
            System.out.print(DateUtil.dateToISO8601String(ver.getBuildDate(), true, true, true, 6, DateUtil.UTC, new DateUtil.TrivialDateToISO8601CalendarFactory()));
            System.out.print(")");
        }
        System.out.println();
        if (ver.isGAECompliant() != null) {
            System.out.print("Google App Engine complian variant: ");
            System.out.println(ver.isGAECompliant() != false ? "Yes" : "No");
        }
        System.out.println();
        System.out.println("Copyright (c) 2014 Attila Szegedi, Daniel Dekany, Jonathan Revusky.");
        System.out.println("Licensed under the Apache License, Version 2.0");
        System.out.println();
        System.out.println("For more information and for updates visit our Web site:");
        System.out.println("http://freemarker.org/");
        System.out.println();
    }
}

