/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.core;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ParameterRole;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.TemplateElement;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility.StandardCompress;
import java.io.IOException;

final class CompressedBlock
extends TemplateElement {
    CompressedBlock(TemplateElement nestedBlock) {
        this.nestedBlock = nestedBlock;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.visitAndTransform(this.nestedBlock, StandardCompress.INSTANCE, null);
        }
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            String nested = this.nestedBlock != null ? this.nestedBlock.getCanonicalForm() : "";
            return "<" + this.getNodeTypeSymbol() + ">" + nested + "</" + this.getNodeTypeSymbol() + ">";
        }
        return this.getNodeTypeSymbol();
    }

    String getNodeTypeSymbol() {
        return "#compress";
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    boolean isIgnorable() {
        return this.nestedBlock == null || this.nestedBlock.isIgnorable();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

