/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.core;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ParameterRole;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.StopException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.TemplateElement;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.debug.impl.DebuggerService;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateException;
import java.io.IOException;

public class DebugBreak
extends TemplateElement {
    public DebugBreak(TemplateElement nestedBlock) {
        this.nestedBlock = nestedBlock;
        nestedBlock.parent = this;
        this.copyLocationFrom(nestedBlock);
    }

    protected void accept(Environment env) throws TemplateException, IOException {
        if (DebuggerService.suspendEnvironment(env, this.getTemplate().getSourceName(), this.nestedBlock.getBeginLine())) {
            throw new StopException(env, "Stopped by debugger");
        }
        this.nestedBlock.accept(env);
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            StringBuffer sb = new StringBuffer();
            sb.append("<#-- ");
            sb.append("debug break");
            if (this.nestedBlock == null) {
                sb.append(" /-->");
            } else {
                sb.append(" -->");
                sb.append(this.nestedBlock.getCanonicalForm());
                sb.append("<#--/ debug break -->");
            }
            return sb.toString();
        }
        return "debug break";
    }

    String getNodeTypeSymbol() {
        return "#debug_break";
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

