/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.core;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Expression;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.LocalContext;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.NonSequenceOrCollectionException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ParameterRole;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.TemplateElement;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core._CoreStringUtils;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.SimpleNumber;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateBooleanModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateCollectionModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelIterator;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

final class IteratorBlock
extends TemplateElement {
    private Expression listExpression;
    private String loopVariableName;
    private boolean isForEach;

    IteratorBlock(Expression listExpression, String loopVariableName, TemplateElement nestedBlock, boolean isForEach) {
        this.listExpression = listExpression;
        this.loopVariableName = loopVariableName;
        this.nestedBlock = nestedBlock;
        this.isForEach = isForEach;
    }

    void accept(Environment env) throws TemplateException, IOException {
        TemplateModel listValue = this.listExpression.eval(env);
        if (listValue == null) {
            if (env.isClassicCompatible()) {
                return;
            }
            this.listExpression.assertNonNull(null, env);
        }
        env.visitIteratorBlock(new Context(listValue));
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        if (this.isForEach) {
            buf.append(_CoreStringUtils.toFTLTopLevelIdentifierReference(this.loopVariableName));
            buf.append(" in ");
            buf.append(this.listExpression.getCanonicalForm());
        } else {
            buf.append(this.listExpression.getCanonicalForm());
            buf.append(" as ");
            buf.append(_CoreStringUtils.toFTLTopLevelIdentifierReference(this.loopVariableName));
        }
        if (canonical) {
            buf.append(">");
            if (this.nestedBlock != null) {
                buf.append(this.nestedBlock.getCanonicalForm());
            }
            buf.append("</");
            buf.append(this.getNodeTypeSymbol());
            buf.append('>');
        }
        return buf.toString();
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.listExpression;
            }
            case 1: {
                return this.loopVariableName;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.LIST_SOURCE;
            }
            case 1: {
                return ParameterRole.TARGET_LOOP_VARIABLE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    String getNodeTypeSymbol() {
        return this.isForEach ? "#foreach" : "#list";
    }

    boolean isNestedBlockRepeater() {
        return true;
    }

    class Context
    implements LocalContext {
        private static final String LOOP_STATE_HAS_NEXT = "_has_next";
        private static final String LOOP_STATE_INDEX = "_index";
        private boolean hasNext;
        private TemplateModel loopVar;
        private int index;
        private Collection variableNames = null;
        private TemplateModel listValue;

        Context(TemplateModel listValue) {
            this.listValue = listValue;
        }

        void runLoop(Environment env) throws TemplateException, IOException {
            if (this.listValue instanceof TemplateCollectionModel) {
                TemplateCollectionModel tcm = (TemplateCollectionModel)this.listValue;
                TemplateModelIterator it = tcm.iterator();
                this.hasNext = it.hasNext();
                while (this.hasNext) {
                    this.loopVar = it.next();
                    this.hasNext = it.hasNext();
                    if (IteratorBlock.this.nestedBlock != null) {
                        env.visitByHiddingParent(IteratorBlock.this.nestedBlock);
                    }
                    ++this.index;
                }
            } else if (this.listValue instanceof TemplateSequenceModel) {
                TemplateSequenceModel tsm = (TemplateSequenceModel)this.listValue;
                int size = tsm.size();
                this.index = 0;
                while (this.index < size) {
                    this.loopVar = tsm.get(this.index);
                    boolean bl = this.hasNext = size > this.index + 1;
                    if (IteratorBlock.this.nestedBlock != null) {
                        env.visitByHiddingParent(IteratorBlock.this.nestedBlock);
                    }
                    ++this.index;
                }
            } else if (env.isClassicCompatible()) {
                this.loopVar = this.listValue;
                if (IteratorBlock.this.nestedBlock != null) {
                    env.visitByHiddingParent(IteratorBlock.this.nestedBlock);
                }
            } else {
                throw new NonSequenceOrCollectionException(IteratorBlock.this.listExpression, this.listValue, env);
            }
        }

        public TemplateModel getLocalVariable(String name) {
            if (name.startsWith(IteratorBlock.this.loopVariableName)) {
                switch (name.length() - IteratorBlock.this.loopVariableName.length()) {
                    case 0: {
                        return this.loopVar;
                    }
                    case 6: {
                        if (!name.endsWith(LOOP_STATE_INDEX)) break;
                        return new SimpleNumber(this.index);
                    }
                    case 9: {
                        if (!name.endsWith(LOOP_STATE_HAS_NEXT)) break;
                        return this.hasNext ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                    }
                }
            }
            return null;
        }

        public Collection getLocalVariableNames() {
            if (this.variableNames == null) {
                this.variableNames = new ArrayList(3);
                this.variableNames.add(IteratorBlock.this.loopVariableName);
                this.variableNames.add(IteratorBlock.this.loopVariableName + LOOP_STATE_INDEX);
                this.variableNames.add(IteratorBlock.this.loopVariableName + LOOP_STATE_HAS_NEXT);
            }
            return this.variableNames;
        }
    }
}

