/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.core;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ParameterRole;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ParseException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.TemplateElement;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;

final class MixedContent
extends TemplateElement {
    MixedContent() {
        this.nestedElements = new ArrayList();
    }

    void addElement(TemplateElement element) {
        this.nestedElements.add(element);
    }

    void addElement(int index, TemplateElement element) {
        this.nestedElements.add(index, element);
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        super.postParseCleanup(stripWhitespace);
        if (this.nestedElements.size() == 1) {
            return (TemplateElement)this.nestedElements.get(0);
        }
        return this;
    }

    void accept(Environment env) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            TemplateElement element = (TemplateElement)this.nestedElements.get(i);
            env.visit(element);
        }
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.nestedElements.size(); ++i) {
                TemplateElement element = (TemplateElement)this.nestedElements.get(i);
                buf.append(element.getCanonicalForm());
            }
            return buf.toString();
        }
        if (this.parent == null) {
            return "root";
        }
        return this.getNodeTypeSymbol();
    }

    protected boolean isOutputCacheable() {
        Enumeration children = this.children();
        while (children.hasMoreElements()) {
            if (((TemplateElement)children.nextElement()).isOutputCacheable()) continue;
            return false;
        }
        return true;
    }

    String getNodeTypeSymbol() {
        return "#mixed_content";
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    boolean isShownInStackTrace() {
        return false;
    }

    boolean isIgnorable() {
        return this.nestedElements == null || this.nestedElements.size() == 0;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

