/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.core;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Expression;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.InvalidReferenceException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.UnexpectedTypeException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core._DelayedJQuote;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core._ErrorDescriptionBuilder;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateNumberModel;

public class NonNumericalException
extends UnexpectedTypeException {
    private static final Class[] EXPECTED_TYPES = new Class[]{TemplateNumberModel.class};

    public NonNumericalException(Environment env) {
        super(env, "Expecting numerical value here");
    }

    public NonNumericalException(String description, Environment env) {
        super(env, description);
    }

    NonNumericalException(_ErrorDescriptionBuilder description, Environment env) {
        super(env, description);
    }

    NonNumericalException(Expression blamed, TemplateModel model, Environment env) throws InvalidReferenceException {
        super(blamed, model, "number", EXPECTED_TYPES, env);
    }

    NonNumericalException(Expression blamed, TemplateModel model, String tip, Environment env) throws InvalidReferenceException {
        super(blamed, model, "number", EXPECTED_TYPES, tip, env);
    }

    NonNumericalException(Expression blamed, TemplateModel model, String[] tips, Environment env) throws InvalidReferenceException {
        super(blamed, model, "number", EXPECTED_TYPES, tips, env);
    }

    static NonNumericalException newMalformedNumberException(Expression blamed, String text, Environment env) {
        return new NonNumericalException(new _ErrorDescriptionBuilder(new Object[]{"Can't convert this string to number: ", new _DelayedJQuote(text)}).blame(blamed), env);
    }
}

