/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.core;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Expression;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ParameterRole;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ParseException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.TemplateElement;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core._CoreStringUtils;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.Template;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateBooleanModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateNumberModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateScalarModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility.StringUtil;
import java.util.Arrays;

final class PropertySetting
extends TemplateElement {
    private final String key;
    private final Expression value;
    static final String[] SETTING_NAMES = new String[]{"boolean_format", "classic_compatible", "date_format", "datetime_format", "locale", "number_format", "output_encoding", "sql_date_and_time_time_zone", "time_format", "time_zone", "url_escaping_charset"};

    PropertySetting(String key, Expression value) {
        this.key = key;
        this.value = value;
    }

    void setLocation(Template template, int beginColumn, int beginLine, int endColumn, int endLine) throws ParseException {
        super.setLocation(template, beginColumn, beginLine, endColumn, endLine);
        if (Arrays.binarySearch(SETTING_NAMES, this.key) < 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Unknown setting name: ");
            sb.append(StringUtil.jQuote(this.key)).append(".");
            String underscoredName = _CoreStringUtils.camelCaseToUnderscored(this.key);
            if (!underscoredName.equals(this.key) && Arrays.binarySearch(SETTING_NAMES, underscoredName) >= 0) {
                sb.append(" Supporting camelCase setting names is planned for FreeMarker 2.4.0; check if an update is available, and if it indeed supports camel case. Until that, use \"").append(underscoredName).append("\".");
            } else if (template.getSettingNames().contains(this.key) || template.getSettingNames().contains(underscoredName)) {
                sb.append(" The setting name is recognized, but changing this setting in a template isn't supported.");
            } else {
                sb.append(" The allowed setting names are: ");
                for (int i = 0; i < SETTING_NAMES.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(SETTING_NAMES[i]);
                }
            }
            throw new ParseException(sb.toString(), template, beginLine, beginColumn, endLine, endColumn);
        }
    }

    void accept(Environment env) throws TemplateException {
        TemplateModel mval = this.value.eval(env);
        String strval = mval instanceof TemplateScalarModel ? ((TemplateScalarModel)mval).getAsString() : (mval instanceof TemplateBooleanModel ? (((TemplateBooleanModel)mval).getAsBoolean() ? "true" : "false") : (mval instanceof TemplateNumberModel ? ((TemplateNumberModel)mval).getAsNumber().toString() : this.value.evalAndCoerceToString(env)));
        env.setSetting(this.key, strval);
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        sb.append(' ');
        sb.append(_CoreStringUtils.toFTLTopLevelTragetIdentifier(this.key));
        sb.append('=');
        sb.append(this.value.getCanonicalForm());
        if (canonical) {
            sb.append("/>");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "#setting";
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.key;
            }
            case 1: {
                return this.value;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.ITEM_KEY;
            }
            case 1: {
                return ParameterRole.ITEM_VALUE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

