/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.core;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Expression;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ListLiteral;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.NonNodeException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.NonSequenceException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ParameterRole;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.StringLiteral;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.TemplateElement;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core._MiscTemplateException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.SimpleSequence;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateHashModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateNodeModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateScalarModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateSequenceModel;
import java.io.IOException;

final class RecurseNode
extends TemplateElement {
    Expression targetNode;
    Expression namespaces;

    RecurseNode(Expression targetNode, Expression namespaces) {
        this.targetNode = targetNode;
        this.namespaces = namespaces;
    }

    void accept(Environment env) throws IOException, TemplateException {
        TemplateModel nss;
        TemplateModel node;
        TemplateModel templateModel = node = this.targetNode == null ? null : this.targetNode.eval(env);
        if (node != null && !(node instanceof TemplateNodeModel)) {
            throw new NonNodeException(this.targetNode, node, "node", env);
        }
        TemplateModel templateModel2 = nss = this.namespaces == null ? null : this.namespaces.eval(env);
        if (this.namespaces instanceof StringLiteral) {
            nss = env.importLib(((TemplateScalarModel)nss).getAsString(), null);
        } else if (this.namespaces instanceof ListLiteral) {
            nss = ((ListLiteral)this.namespaces).evaluateStringsToNamespaces(env);
        }
        if (nss != null) {
            if (nss instanceof TemplateHashModel) {
                SimpleSequence ss = new SimpleSequence(1);
                ss.add(nss);
                nss = ss;
            } else if (!(nss instanceof TemplateSequenceModel)) {
                if (this.namespaces != null) {
                    throw new NonSequenceException(this.namespaces, nss, env);
                }
                throw new _MiscTemplateException(env, "Expecting a sequence of namespaces after \"using\"");
            }
        }
        env.recurse((TemplateNodeModel)node, (TemplateSequenceModel)nss);
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        if (this.targetNode != null) {
            sb.append(' ');
            sb.append(this.targetNode.getCanonicalForm());
        }
        if (this.namespaces != null) {
            sb.append(" using ");
            sb.append(this.namespaces.getCanonicalForm());
        }
        if (canonical) {
            sb.append("/>");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "#recurse";
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.targetNode;
            }
            case 1: {
                return this.namespaces;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.NODE;
            }
            case 1: {
                return ParameterRole.NAMESPACE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

