/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.core;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Assignment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.AssignmentInstruction;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Comment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.LibraryLoad;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Macro;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.ParameterRole;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.PropertySetting;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.TemplateElement;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.TrimInstruction;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility.StringUtil;
import java.io.IOException;

public final class TextBlock
extends TemplateElement {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    static final TextBlock EMPTY_BLOCK = new TextBlock(EMPTY_CHAR_ARRAY, false);
    private char[] text;
    private final boolean unparsed;

    public TextBlock(String text) {
        this(text, false);
    }

    public TextBlock(String text, boolean unparsed) {
        this(text.toCharArray(), unparsed);
    }

    private TextBlock(char[] text, boolean unparsed) {
        this.text = text;
        this.unparsed = unparsed;
    }

    public void accept(Environment env) throws IOException {
        env.getOut().write(this.text);
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            String text = new String(this.text);
            if (this.unparsed) {
                return "<#noparse>" + text + "</#noparse>";
            }
            return text;
        }
        return "text " + StringUtil.jQuote(new String(this.text));
    }

    String getNodeTypeSymbol() {
        return "#text";
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.text);
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.CONTENT;
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) {
        if (this.text.length == 0) {
            return this;
        }
        int openingCharsToStrip = 0;
        int trailingCharsToStrip = 0;
        boolean deliberateLeftTrim = this.deliberateLeftTrim();
        boolean deliberateRightTrim = this.deliberateRightTrim();
        if (!stripWhitespace || this.text.length == 0) {
            return this;
        }
        if (this.parent.parent == null && this.previousSibling() == null) {
            return this;
        }
        if (!deliberateLeftTrim) {
            trailingCharsToStrip = this.trailingCharsToStrip();
        }
        if (!deliberateRightTrim) {
            openingCharsToStrip = this.openingCharsToStrip();
        }
        if (openingCharsToStrip == 0 && trailingCharsToStrip == 0) {
            return this;
        }
        this.text = TextBlock.substring(this.text, openingCharsToStrip, this.text.length - trailingCharsToStrip);
        if (openingCharsToStrip > 0) {
            ++this.beginLine;
            this.beginColumn = 1;
        }
        if (trailingCharsToStrip > 0) {
            this.endColumn = 0;
        }
        return this;
    }

    private boolean deliberateLeftTrim() {
        boolean result = false;
        for (TemplateElement elem = this.nextTerminalNode(); elem != null && elem.beginLine == this.endLine; elem = elem.nextTerminalNode()) {
            if (!(elem instanceof TrimInstruction)) continue;
            TrimInstruction ti = (TrimInstruction)elem;
            if (!ti.left && !ti.right) {
                result = true;
            }
            if (!ti.left) continue;
            result = true;
            int lastNewLineIndex = this.lastNewLineIndex();
            if (lastNewLineIndex < 0 && this.beginColumn != 1) continue;
            char[] firstPart = TextBlock.substring(this.text, 0, lastNewLineIndex + 1);
            char[] lastLine = TextBlock.substring(this.text, 1 + lastNewLineIndex);
            if (StringUtil.isTrimmableToEmpty(lastLine)) {
                this.text = firstPart;
                this.endColumn = 0;
                continue;
            }
            int i = 0;
            while (Character.isWhitespace(lastLine[i])) {
                ++i;
            }
            char[] printablePart = TextBlock.substring(lastLine, i);
            this.text = TextBlock.concat(firstPart, printablePart);
        }
        if (result) {
            // empty if block
        }
        return result;
    }

    private boolean deliberateRightTrim() {
        boolean result = false;
        for (TemplateElement elem = this.prevTerminalNode(); elem != null && elem.endLine == this.beginLine; elem = elem.prevTerminalNode()) {
            if (!(elem instanceof TrimInstruction)) continue;
            TrimInstruction ti = (TrimInstruction)elem;
            if (!ti.left && !ti.right) {
                result = true;
            }
            if (!ti.right) continue;
            result = true;
            int firstLineIndex = this.firstNewLineIndex() + 1;
            if (firstLineIndex == 0) {
                return false;
            }
            if (this.text.length > firstLineIndex && this.text[firstLineIndex - 1] == '\r' && this.text[firstLineIndex] == '\n') {
                ++firstLineIndex;
            }
            char[] trailingPart = TextBlock.substring(this.text, firstLineIndex);
            char[] openingPart = TextBlock.substring(this.text, 0, firstLineIndex);
            if (StringUtil.isTrimmableToEmpty(openingPart)) {
                this.text = trailingPart;
                ++this.beginLine;
                this.beginColumn = 1;
                continue;
            }
            int lastNonWS = openingPart.length - 1;
            while (Character.isWhitespace(this.text[lastNonWS])) {
                --lastNonWS;
            }
            char[] printablePart = TextBlock.substring(this.text, 0, lastNonWS + 1);
            if (StringUtil.isTrimmableToEmpty(trailingPart)) {
                boolean trimTrailingPart = true;
                for (TemplateElement te = this.nextTerminalNode(); te != null && te.beginLine == this.endLine; te = te.nextTerminalNode()) {
                    if (te.heedsOpeningWhitespace()) {
                        trimTrailingPart = false;
                    }
                    if (!(te instanceof TrimInstruction) || !((TrimInstruction)te).left) continue;
                    trimTrailingPart = true;
                    break;
                }
                if (trimTrailingPart) {
                    trailingPart = EMPTY_CHAR_ARRAY;
                }
            }
            this.text = TextBlock.concat(printablePart, trailingPart);
        }
        return result;
    }

    private int firstNewLineIndex() {
        int result;
        String content = new String(this.text);
        int newlineIndex1 = content.indexOf(10);
        int newlineIndex2 = content.indexOf(13);
        int n = result = newlineIndex1 >= 0 ? newlineIndex1 : newlineIndex2;
        if (newlineIndex1 >= 0 && newlineIndex2 >= 0) {
            result = Math.min(newlineIndex1, newlineIndex2);
        }
        return result;
    }

    private int lastNewLineIndex() {
        String content = new String(this.text);
        return Math.max(content.lastIndexOf(13), content.lastIndexOf(10));
    }

    private int openingCharsToStrip() {
        int newlineIndex = this.firstNewLineIndex();
        if (newlineIndex == -1 && this.beginColumn != 1) {
            return 0;
        }
        if (this.text.length > ++newlineIndex && newlineIndex > 0 && this.text[newlineIndex - 1] == '\r' && this.text[newlineIndex] == '\n') {
            ++newlineIndex;
        }
        if (new String(this.text).substring(0, newlineIndex).trim().length() > 0) {
            return 0;
        }
        for (TemplateElement elem = this.prevTerminalNode(); elem != null && elem.endLine == this.beginLine; elem = elem.prevTerminalNode()) {
            if (!elem.heedsOpeningWhitespace()) continue;
            return 0;
        }
        return newlineIndex;
    }

    private int trailingCharsToStrip() {
        String content = new String(this.text);
        int lastNewlineIndex = this.lastNewLineIndex();
        if (lastNewlineIndex == -1 && this.beginColumn != 1) {
            return 0;
        }
        String substring = content.substring(lastNewlineIndex + 1);
        if (substring.trim().length() > 0) {
            return 0;
        }
        for (TemplateElement elem = this.nextTerminalNode(); elem != null && elem.beginLine == this.endLine; elem = elem.nextTerminalNode()) {
            if (!elem.heedsTrailingWhitespace()) continue;
            return 0;
        }
        return substring.length();
    }

    boolean heedsTrailingWhitespace() {
        if (this.isIgnorable()) {
            return false;
        }
        for (int i = 0; i < this.text.length; ++i) {
            char c = this.text[i];
            if (c == '\n' || c == '\r') {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            return true;
        }
        return true;
    }

    boolean heedsOpeningWhitespace() {
        if (this.isIgnorable()) {
            return false;
        }
        for (int i = this.text.length - 1; i >= 0; --i) {
            char c = this.text[i];
            if (c == '\n' || c == '\r') {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            return true;
        }
        return true;
    }

    boolean isIgnorable() {
        if (this.text == null || this.text.length == 0) {
            return true;
        }
        if (!StringUtil.isTrimmableToEmpty(this.text)) {
            return false;
        }
        boolean atTopLevel = this.getParent().getParent() == null;
        TemplateElement prevSibling = this.previousSibling();
        TemplateElement nextSibling = this.nextSibling();
        return (prevSibling == null && atTopLevel || this.nonOutputtingType(prevSibling)) && (nextSibling == null && atTopLevel || this.nonOutputtingType(nextSibling));
    }

    private boolean nonOutputtingType(TemplateElement element) {
        return element instanceof Macro || element instanceof Assignment || element instanceof AssignmentInstruction || element instanceof PropertySetting || element instanceof LibraryLoad || element instanceof Comment;
    }

    private static char[] substring(char[] c, int from, int to) {
        char[] c2 = new char[to - from];
        System.arraycopy(c, from, c2, 0, c2.length);
        return c2;
    }

    private static char[] substring(char[] c, int from) {
        return TextBlock.substring(c, from, c.length);
    }

    private static char[] concat(char[] c1, char[] c2) {
        char[] c = new char[c1.length + c2.length];
        System.arraycopy(c1, 0, c, 0, c1.length);
        System.arraycopy(c2, 0, c, c1.length, c2.length);
        return c;
    }

    boolean isOutputCacheable() {
        return true;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

