/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.beans;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.beans.BeansWrapper;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.beans.OverloadedMethods;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.beans.OverloadedMethodsModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.beans.SimpleMethodModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.log.Logger;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateCollectionModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateHashModelEx;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class StaticModel
implements TemplateHashModelEx {
    private static final Logger LOG = Logger.getLogger("de.thomaskrille.dropwizard_template_config.redist.freemarker.beans");
    private final Class clazz;
    private final BeansWrapper wrapper;
    private final Map map = new HashMap();

    StaticModel(Class clazz, BeansWrapper wrapper) throws TemplateModelException {
        this.clazz = clazz;
        this.wrapper = wrapper;
        this.populate();
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object model = this.map.get(key);
        if (model instanceof TemplateModel) {
            return (TemplateModel)model;
        }
        if (model instanceof Field) {
            try {
                return this.wrapper.getOuterIdentity().wrap(((Field)model).get(null));
            }
            catch (IllegalAccessException e) {
                throw new TemplateModelException("Illegal access for field " + key + " of class " + this.clazz.getName());
            }
        }
        throw new TemplateModelException("No such key: " + key + " in class " + this.clazz.getName());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.keySet());
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.values());
    }

    private void populate() throws TemplateModelException {
        if (!Modifier.isPublic(this.clazz.getModifiers())) {
            throw new TemplateModelException("Can't wrap the non-public class " + this.clazz.getName());
        }
        if (this.wrapper.getExposureLevel() == 3) {
            return;
        }
        Field[] fields = this.clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int mod = field.getModifiers();
            if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod)) continue;
            if (Modifier.isFinal(mod)) {
                try {
                    this.map.put(field.getName(), this.wrapper.getOuterIdentity().wrap(field.get(null)));
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            this.map.put(field.getName(), field);
        }
        if (this.wrapper.getExposureLevel() < 2) {
            Method[] methods = this.clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                OverloadedMethods overloadedMethods;
                Method method = methods[i];
                int mod = method.getModifiers();
                if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !this.wrapper.getClassIntrospector().isAllowedToExpose(method)) continue;
                String name = method.getName();
                Object obj = this.map.get(name);
                if (obj instanceof Method) {
                    overloadedMethods = new OverloadedMethods(this.wrapper.is2321Bugfixed());
                    overloadedMethods.addMethod((Method)obj);
                    overloadedMethods.addMethod(method);
                    this.map.put(name, overloadedMethods);
                    continue;
                }
                if (obj instanceof OverloadedMethods) {
                    overloadedMethods = (OverloadedMethods)obj;
                    overloadedMethods.addMethod(method);
                    continue;
                }
                if (obj != null && LOG.isInfoEnabled()) {
                    LOG.info("Overwriting value [" + obj + "] for " + " key '" + name + "' with [" + method + "] in static model for " + this.clazz.getName());
                }
                this.map.put(name, method);
            }
            Iterator entries = this.map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object value = entry.getValue();
                if (value instanceof Method) {
                    Method method = (Method)value;
                    entry.setValue(new SimpleMethodModel(null, method, method.getParameterTypes(), this.wrapper));
                    continue;
                }
                if (!(value instanceof OverloadedMethods)) continue;
                entry.setValue(new OverloadedMethodsModel(null, (OverloadedMethods)value, this.wrapper));
            }
        }
    }
}

