/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.dom;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.dom.ElementModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.dom.NodeListModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.dom.NodeModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateHashModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class DocumentModel
extends NodeModel
implements TemplateHashModel {
    private ElementModel rootElement;

    DocumentModel(Document doc) {
        super(doc);
    }

    public String getNodeName() {
        return "@document";
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key.equals("*")) {
            return this.getRootElement();
        }
        if (key.equals("**")) {
            NodeList nl = ((Document)this.node).getElementsByTagName("*");
            return new NodeListModel(nl, (NodeModel)this);
        }
        if (StringUtil.isXMLID(key)) {
            ElementModel em = (ElementModel)NodeModel.wrap(((Document)this.node).getDocumentElement());
            if (em.matchesName(key, Environment.getCurrentEnvironment())) {
                return em;
            }
            return new NodeListModel(this);
        }
        return super.get(key);
    }

    ElementModel getRootElement() {
        if (this.rootElement == null) {
            this.rootElement = (ElementModel)DocumentModel.wrap(((Document)this.node).getDocumentElement());
        }
        return this.rootElement;
    }

    public boolean isEmpty() {
        return false;
    }
}

