/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.template;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.util.WrapperTemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.AdapterTemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.ObjectWrapper;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateCollectionModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelIterator;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.Iterator;

public class DefaultIteratorAdapter
extends WrappingTemplateModel
implements TemplateCollectionModel,
AdapterTemplateModel,
WrapperTemplateModel,
Serializable {
    private final Iterator iterator;
    private boolean iteratorOwned;

    public static DefaultIteratorAdapter adapt(Iterator iterator, ObjectWrapper wrapper) {
        return new DefaultIteratorAdapter(iterator, wrapper);
    }

    private DefaultIteratorAdapter(Iterator iterator, ObjectWrapper wrapper) {
        super(wrapper);
        this.iterator = iterator;
    }

    public Object getWrappedObject() {
        return this.iterator;
    }

    public Object getAdaptedObject(Class hint) {
        return this.getWrappedObject();
    }

    public TemplateModelIterator iterator() throws TemplateModelException {
        return new SimpleTemplateModelIterator();
    }

    private class SimpleTemplateModelIterator
    implements TemplateModelIterator {
        private boolean iteratorOwnedByMe;

        private SimpleTemplateModelIterator() {
        }

        public TemplateModel next() throws TemplateModelException {
            if (!this.iteratorOwnedByMe) {
                this.takeIteratorOwnership();
            }
            if (!DefaultIteratorAdapter.this.iterator.hasNext()) {
                throw new TemplateModelException("The collection has no more items.");
            }
            Object value = DefaultIteratorAdapter.this.iterator.next();
            return value instanceof TemplateModel ? (TemplateModel)value : DefaultIteratorAdapter.this.wrap(value);
        }

        public boolean hasNext() throws TemplateModelException {
            if (!this.iteratorOwnedByMe) {
                this.takeIteratorOwnership();
            }
            return DefaultIteratorAdapter.this.iterator.hasNext();
        }

        private void takeIteratorOwnership() throws TemplateModelException {
            if (DefaultIteratorAdapter.this.iteratorOwned) {
                throw new TemplateModelException("This collection value wraps a java.util.Iterator, thus it can be listed only once.");
            }
            DefaultIteratorAdapter.this.iteratorOwned = true;
            this.iteratorOwnedByMe = true;
        }
    }
}

