/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.template;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core._DelayedShortClassName;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.core._TemplateModelException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.util.WrapperTemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.AdapterTemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.ObjectWrapperAndUnwrapper;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateCollectionModelEx;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelIterator;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelWithAPISupport;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.WrappingTemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility.ObjectWrapperWithAPISupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class DefaultNonListCollectionAdapter
extends WrappingTemplateModel
implements TemplateCollectionModelEx,
AdapterTemplateModel,
WrapperTemplateModel,
TemplateModelWithAPISupport,
Serializable {
    private final Collection collection;

    public static DefaultNonListCollectionAdapter adapt(Collection collection, ObjectWrapperWithAPISupport wrapper) {
        return new DefaultNonListCollectionAdapter(collection, wrapper);
    }

    private DefaultNonListCollectionAdapter(Collection collection, ObjectWrapperWithAPISupport wrapper) {
        super(wrapper);
        this.collection = collection;
    }

    public TemplateModelIterator iterator() throws TemplateModelException {
        return new IteratorAdapter(this.collection.iterator());
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public Object getWrappedObject() {
        return this.collection;
    }

    public Object getAdaptedObject(Class hint) {
        return this.getWrappedObject();
    }

    public boolean contains(TemplateModel item) throws TemplateModelException {
        Object itemPojo = ((ObjectWrapperAndUnwrapper)this.getObjectWrapper()).unwrap(item);
        try {
            return this.collection.contains(itemPojo);
        }
        catch (ClassCastException e) {
            throw new _TemplateModelException((Throwable)e, new Object[]{"Failed to check if the collection contains the item. Probably the item's Java type, ", itemPojo != null ? new _DelayedShortClassName(itemPojo.getClass()) : "Null", ", doesn't match the type of (some of) the collection items; see cause exception."});
        }
    }

    public TemplateModel getAPI() throws TemplateModelException {
        return ((ObjectWrapperWithAPISupport)this.getObjectWrapper()).wrapAsAPI(this.collection);
    }

    private class IteratorAdapter
    implements TemplateModelIterator {
        private final Iterator iterator;

        IteratorAdapter(Iterator iterator) {
            this.iterator = iterator;
        }

        public TemplateModel next() throws TemplateModelException {
            if (!this.iterator.hasNext()) {
                throw new TemplateModelException("The collection has no more items.");
            }
            Object value = this.iterator.next();
            return value instanceof TemplateModel ? (TemplateModel)value : DefaultNonListCollectionAdapter.this.wrap(value);
        }

        public boolean hasNext() throws TemplateModelException {
            return this.iterator.hasNext();
        }
    }
}

