/*
 * Decompiled with CFR 0.152.
 */
package de.thomaskrille.dropwizard_template_config.redist.freemarker.template.utility;

import de.thomaskrille.dropwizard_template_config.redist.freemarker.core.Environment;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.ext.util.WrapperTemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.AdapterTemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.ObjectWrapper;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateBooleanModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateCollectionModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateDateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateHashModelEx;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelException;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateModelIterator;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateNumberModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateScalarModel;
import de.thomaskrille.dropwizard_template_config.redist.freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;
import java.util.HashMap;

public class DeepUnwrap {
    private static final Class OBJECT_CLASS = Object.class;

    public static Object unwrap(TemplateModel model) throws TemplateModelException {
        return DeepUnwrap.unwrap(model, false);
    }

    public static Object permissiveUnwrap(TemplateModel model) throws TemplateModelException {
        return DeepUnwrap.unwrap(model, true);
    }

    public static Object premissiveUnwrap(TemplateModel model) throws TemplateModelException {
        return DeepUnwrap.unwrap(model, true);
    }

    private static Object unwrap(TemplateModel model, boolean permissive) throws TemplateModelException {
        ObjectWrapper wrapper;
        Environment env = Environment.getCurrentEnvironment();
        TemplateModel nullModel = null;
        if (env != null && (wrapper = env.getObjectWrapper()) != null) {
            nullModel = wrapper.wrap(null);
        }
        return DeepUnwrap.unwrap(model, nullModel, permissive);
    }

    private static Object unwrap(TemplateModel model, TemplateModel nullModel, boolean permissive) throws TemplateModelException {
        if (model instanceof AdapterTemplateModel) {
            return ((AdapterTemplateModel)model).getAdaptedObject(OBJECT_CLASS);
        }
        if (model instanceof WrapperTemplateModel) {
            return ((WrapperTemplateModel)model).getWrappedObject();
        }
        if (model == nullModel) {
            return null;
        }
        if (model instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)model).getAsString();
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber();
        }
        if (model instanceof TemplateDateModel) {
            return ((TemplateDateModel)model).getAsDate();
        }
        if (model instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)model).getAsBoolean();
        }
        if (model instanceof TemplateSequenceModel) {
            TemplateSequenceModel seq = (TemplateSequenceModel)model;
            ArrayList<Object> list = new ArrayList<Object>(seq.size());
            for (int i = 0; i < seq.size(); ++i) {
                list.add(DeepUnwrap.unwrap(seq.get(i), nullModel, permissive));
            }
            return list;
        }
        if (model instanceof TemplateCollectionModel) {
            TemplateCollectionModel coll = (TemplateCollectionModel)model;
            ArrayList<Object> list = new ArrayList<Object>();
            TemplateModelIterator it = coll.iterator();
            while (it.hasNext()) {
                list.add(DeepUnwrap.unwrap(it.next(), nullModel, permissive));
            }
            return list;
        }
        if (model instanceof TemplateHashModelEx) {
            TemplateHashModelEx hash = (TemplateHashModelEx)model;
            HashMap<String, Object> map = new HashMap<String, Object>();
            TemplateModelIterator keys = hash.keys().iterator();
            while (keys.hasNext()) {
                String key = (String)DeepUnwrap.unwrap(keys.next(), nullModel, permissive);
                map.put(key, DeepUnwrap.unwrap(hash.get(key), nullModel, permissive));
            }
            return map;
        }
        if (permissive) {
            return model;
        }
        throw new TemplateModelException("Cannot deep-unwrap model of type " + model.getClass().getName());
    }
}

