/*
 * Decompiled with CFR 0.152.
 */
package de.tilokowalski.util;

import de.tilokowalski.util.ToStringDontResolve;
import de.tilokowalski.util.ToStringIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ToString {
    private static final char TS_PARANTHESIS_OPEN = '[';
    private static final char TS_PARANTHESIS_CLOSE = ']';
    private static final char TS_PARANTHESIS_STRING = '\"';
    private static final char TS_EQUALS = '=';
    public static final char TS_DELIMITER_SL = ',';
    public static final char TS_DELIMITER_ML = '\n';
    public static final int TS_LEVEL_ONLY = 0;
    public static final int TS_LEVEL_DEEP = -1;
    public static final String TS_EXPR_NULL = "NULL";
    public static final String TS_EXPR_CIRC_REF = "PARENT";
    private Object object;
    private char delimiter;
    private int nesting;
    private int level;
    private boolean resolve;
    private static ArrayList<Object> alreadyResolved = new ArrayList();

    public String toString() {
        try {
            return this.buildFromAttributes();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String buildFromAttributes() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getObject().getClass().getSimpleName());
        stringBuilder.append('[');
        if (this.getNesting() == 0) {
            ToString.getAlreadyResolved().clear();
        }
        if (!ToString.getAlreadyResolved().contains(this.object)) {
            if (this.getObject() instanceof Collection) {
                Collection collection = (Collection)this.getObject();
                stringBuilder = this.appendCollection(stringBuilder, collection);
            } else if (this.getObject() instanceof Map) {
                Collection collection = ((Map)this.getObject()).values();
                stringBuilder = this.appendCollection(stringBuilder, collection);
            } else if (this.getObject().getClass().isArray()) {
                List<Object> collection = Arrays.asList(this.getObject());
                stringBuilder = this.appendCollection(stringBuilder, collection);
            } else {
                if (this.getDelimiter() == '\n') {
                    stringBuilder.append(this.getDelimiter());
                }
                boolean firstField = true;
                for (Field field : this.getDeclaredFields(this.getObject(), this.getLevel())) {
                    this.validateFieldAnnotations(field);
                    if (this.getNesting() > 0 && !this.isResolve() || !this.isFieldIncluded(field)) continue;
                    if (!firstField) {
                        stringBuilder.append(this.getDelimiter());
                    }
                    if (this.getDelimiter() == '\n') {
                        stringBuilder.append(ToString.getIndentation(this.getNesting()));
                    }
                    stringBuilder = this.appendValue(stringBuilder, field, this.getObject());
                    if (!firstField) continue;
                    firstField = false;
                }
                if (this.getDelimiter() == '\n') {
                    stringBuilder.append(this.getDelimiter());
                    stringBuilder.append(ToString.getIndentation(this.getNesting() - 1));
                }
            }
        } else {
            stringBuilder.append(TS_EXPR_CIRC_REF);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private ArrayList<Field> getDeclaredFields(Object object, int level) {
        ArrayList<Field> result = new ArrayList<Field>();
        Class<?> currentClass = object.getClass();
        int iteration = 0;
        while (currentClass != null) {
            for (Field field : currentClass.getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    if ((currentClass.isArray() || Collection.class.isAssignableFrom(currentClass) || Map.class.isAssignableFrom(currentClass)) && !field.getName().equals("elementData")) continue;
                    result.add(field);
                }
                catch (InaccessibleObjectException inaccessibleObjectException) {
                    // empty catch block
                }
            }
            currentClass = currentClass.getSuperclass();
            if (level != -1 && iteration == level) break;
            ++iteration;
        }
        return result;
    }

    private boolean isFieldIncluded(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        return field.getAnnotation(ToStringIgnore.class) == null;
    }

    private void validateFieldAnnotations(Field field) throws Exception {
        if (field.getAnnotation(ToStringDontResolve.class) != null) {
            if (field.getAnnotation(ToStringIgnore.class) != null) {
                throw new Exception("annotations " + ToStringIgnore.class.getSimpleName() + " and " + ToStringDontResolve.class.getSimpleName() + " are not compatible");
            }
            if (!(Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType()) || field.getClass().isArray())) {
                throw new Exception("annotation " + ToStringDontResolve.class + " is not supported for field " + field.getName() + " of type " + field.getType().getSimpleName());
            }
        }
    }

    private StringBuilder appendValue(StringBuilder result, Field field, Object object) {
        result.append(field.getName());
        result.append('=');
        Object value = null;
        try {
            value = field.get(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (value == null) {
            result.append(TS_EXPR_NULL);
        } else if (field.getType().isPrimitive()) {
            result.append(value);
        } else if (field.getType() == String.class) {
            result.append("\"" + value + "\"");
        } else if (field.getType() == Date.class) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            result.append(format.format(value));
        } else if (field.getType() == Integer.class) {
            result.append((Integer)value);
        } else {
            boolean resolve = this.isResolve();
            if (field.isAnnotationPresent(ToStringDontResolve.class)) {
                resolve = false;
            }
            result.append(ToString.createCustom(value, this.getDelimiter(), this.getNesting() + 1, this.getLevel(), resolve));
        }
        alreadyResolved.add(object);
        return result;
    }

    private StringBuilder appendCollection(StringBuilder result, Collection<?> collection) {
        if (collection.isEmpty() || !this.isResolve()) {
            result.append(collection.size());
        } else {
            for (Object entry : collection) {
                result.append(this.getDelimiter());
                result.append(ToString.getIndentation(this.getNesting()));
                result.append(ToString.createCustom(entry, this.getDelimiter(), this.getNesting() + 1, this.getLevel(), this.isResolve()));
            }
            result.append(this.getDelimiter());
            result.append(ToString.getIndentation(this.getNesting() - 1));
        }
        return result;
    }

    private static String getIndentation(int n) {
        return new String("\t").repeat(n + 1);
    }

    public static void addAlreadyResolved(Object alreadyResolved) {
        ToString.alreadyResolved.add(alreadyResolved);
    }

    public static String create(Object object) {
        return new ToString(object, ',', 0, -1, false).toString();
    }

    public static String createDump(Object object) {
        return new ToString(object, '\n', 0, -1, true).toString();
    }

    public static String createCustom(Object object, char delimiter, int nesting, int level, boolean resolve) {
        return new ToString(object, delimiter, nesting, level, resolve).toString();
    }

    private ToString(Object object, char delimiter, int nesting, int level, boolean resolve) {
        this.object = object;
        this.delimiter = delimiter;
        this.nesting = nesting;
        this.level = level;
        this.resolve = resolve;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public int getNesting() {
        return this.nesting;
    }

    public void setNesting(int nesting) {
        this.nesting = nesting;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isResolve() {
        return this.resolve;
    }

    public void setResolve(boolean resolve) {
        this.resolve = resolve;
    }

    public static ArrayList<Object> getAlreadyResolved() {
        return alreadyResolved;
    }
}

