/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc.serializer;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLRPCRuntimeException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.Serializer;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import de.timroes.axmlrpc.xmlcreator.XmlElement;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArraySerializer
implements Serializer {
    private static final String ARRAY_DATA = "data";
    private static final String ARRAY_VALUE = "value";

    @Override
    public Object deserialize(Element content) throws XMLRPCException {
        ArrayList<Object> list = new ArrayList<Object>();
        Element data = XMLUtil.getOnlyChildElement(content.getChildNodes());
        if (!ARRAY_DATA.equals(data.getNodeName())) {
            throw new XMLRPCException("The array must contain one data tag.");
        }
        for (int i = 0; i < data.getChildNodes().getLength(); ++i) {
            Node value = data.getChildNodes().item(i);
            if (value == null || value.getNodeType() == 3 && value.getNodeValue().trim().length() <= 0 || value.getNodeType() == 8) continue;
            if (value.getNodeType() != 1) {
                throw new XMLRPCException("Wrong element inside of array.");
            }
            list.add(SerializerHandler.getDefault().deserialize((Element)value));
        }
        return list.toArray();
    }

    @Override
    public XmlElement serialize(Object object) {
        Iterable iter = (Iterable)object;
        XmlElement array = new XmlElement("array");
        XmlElement data = new XmlElement(ARRAY_DATA);
        array.addChildren(data);
        try {
            for (Object obj : iter) {
                XmlElement e = new XmlElement(ARRAY_VALUE);
                e.addChildren(SerializerHandler.getDefault().serialize(obj));
                data.addChildren(e);
            }
        }
        catch (XMLRPCException ex) {
            throw new XMLRPCRuntimeException(ex);
        }
        return array;
    }
}

