/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc.serializer;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.Serializer;
import de.timroes.axmlrpc.xmlcreator.XmlElement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.w3c.dom.Element;

public class DateTimeSerializer
implements Serializer {
    private static final String DATETIME_FORMAT = "yyyyMMdd'T'HH:mm:ss";
    private static final SimpleDateFormat DATE_FORMATER = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    @Override
    public Object deserialize(Element content) throws XMLRPCException {
        try {
            return DATE_FORMATER.parse(XMLUtil.getOnlyTextContent(content.getChildNodes()));
        }
        catch (ParseException ex) {
            throw new XMLRPCException("Unable to parse given date.", ex);
        }
    }

    @Override
    public XmlElement serialize(Object object) {
        return XMLUtil.makeXmlTag("dateTime.iso8601", DATE_FORMATER.format(object));
    }
}

